/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternsChangedEvent;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.models.system.responses.GrokPatternList;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/system/grok")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="System/Grok", description="Manage grok patterns")
public class GrokResource
extends RestResource {
    private static final Pattern GROK_LINE_PATTERN = Pattern.compile("^(\\w+)[ \t]+(.*)$");
    private final GrokPatternService grokPatternService;
    private final ClusterEventBus clusterBus;

    @Inject
    public GrokResource(GrokPatternService grokPatternService, ClusterEventBus clusterBus) {
        this.grokPatternService = grokPatternService;
        this.clusterBus = clusterBus;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all existing grok patterns")
    public GrokPatternList listGrokPatterns() {
        this.checkPermission("inputs:read");
        return GrokPatternList.create(this.grokPatternService.loadAll());
    }

    @GET
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Get the existing grok pattern")
    public GrokPattern listPattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId) throws NotFoundException {
        this.checkPermission("inputs:read");
        return this.grokPatternService.load(patternId);
    }

    @POST
    @Timed
    @ApiOperation(value="Add a new named pattern", response=GrokPattern.class)
    @AuditEvent(type="server:grok_pattern:create")
    public Response createPattern(@ApiParam(name="pattern", required=true) @Valid @NotNull GrokPattern pattern) throws ValidationException {
        this.checkPermission("inputs:create");
        GrokPattern newPattern = this.grokPatternService.save(pattern.toBuilder().id(null).build());
        this.clusterBus.post(GrokPatternsChangedEvent.create(Collections.emptySet(), Sets.newHashSet((Object[])new String[]{newPattern.name()})));
        URI patternUri = this.getUriBuilderToSelf().path(GrokResource.class, "listPattern").build(new Object[]{newPattern.id()});
        return Response.created((URI)patternUri).entity((Object)newPattern).build();
    }

    @PUT
    @Timed
    @ApiOperation(value="Add a list of new patterns")
    @AuditEvent(type="server:grok_pattern_import:create")
    public Response bulkUpdatePatterns(@ApiParam(name="patterns", required=true) @NotNull GrokPatternList patternList, @ApiParam(name="replace", value="Replace all patterns with the new ones.") @QueryParam(value="replace") @DefaultValue(value="false") boolean replace) throws ValidationException {
        this.checkPermission("inputs:create");
        HashSet updatedPatternNames = Sets.newHashSet();
        for (GrokPattern pattern : patternList.patterns()) {
            updatedPatternNames.add(pattern.name());
            if (this.grokPatternService.validate(pattern)) continue;
            throw new ValidationException("Invalid pattern " + pattern + ". Did not save any patterns.");
        }
        this.grokPatternService.saveAll(patternList.patterns(), replace);
        this.clusterBus.post(GrokPatternsChangedEvent.create(Collections.emptySet(), updatedPatternNames));
        return Response.accepted().build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Timed
    @ApiOperation(value="Add a list of new patterns")
    @AuditEvent(type="server:grok_pattern_import:create")
    public Response bulkUpdatePatternsFromTextFile(@ApiParam(name="patterns", required=true) @NotNull InputStream patternsFile, @ApiParam(name="replace", value="Replace all patterns with the new ones.") @QueryParam(value="replace") @DefaultValue(value="false") boolean replace) throws ValidationException, IOException {
        this.checkPermission("inputs:create");
        List<GrokPattern> grokPatterns = this.readGrokPatterns(patternsFile);
        if (!grokPatterns.isEmpty()) {
            HashSet updatedPatternNames = Sets.newHashSetWithExpectedSize((int)grokPatterns.size());
            for (GrokPattern pattern : grokPatterns) {
                updatedPatternNames.add(pattern.name());
                if (this.grokPatternService.validate(pattern)) continue;
                throw new ValidationException("Invalid pattern " + pattern + ". Did not save any patterns.");
            }
            this.grokPatternService.saveAll(grokPatterns, replace);
            this.clusterBus.post(GrokPatternsChangedEvent.create(Collections.emptySet(), updatedPatternNames));
        }
        return Response.accepted().build();
    }

    /*
     * Exception decompiling
     */
    private List<GrokPattern> readGrokPatterns(InputStream patternList) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @PUT
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Update an existing pattern")
    @AuditEvent(type="server:grok_pattern:update")
    public GrokPattern updatePattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId, @ApiParam(name="pattern", required=true) GrokPattern pattern) throws NotFoundException, ValidationException {
        this.checkPermission("inputs:edit");
        GrokPattern oldPattern = this.grokPatternService.load(patternId);
        HashSet deletedNames = Sets.newHashSet((Object[])new String[]{oldPattern.name()});
        HashSet updatedNames = Sets.newHashSet((Object[])new String[]{pattern.name()});
        GrokPattern toSave = oldPattern.toBuilder().name(pattern.name()).pattern(pattern.pattern()).build();
        this.clusterBus.post(GrokPatternsChangedEvent.create(deletedNames, updatedNames));
        return this.grokPatternService.save(toSave);
    }

    @DELETE
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Remove an existing pattern by id")
    @AuditEvent(type="server:grok_pattern:delete")
    public void removePattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId) throws NotFoundException {
        this.checkPermission("inputs:edit");
        GrokPattern pattern = this.grokPatternService.load(patternId);
        this.clusterBus.post(GrokPatternsChangedEvent.create(Sets.newHashSet((Object[])new String[]{pattern.name()}), Collections.emptySet()));
        if (this.grokPatternService.delete(patternId) == 0) {
            throw new javax.ws.rs.NotFoundException("Couldn't remove Grok pattern with ID " + patternId);
        }
    }

    private static /* synthetic */ GrokPattern lambda$readGrokPatterns$1(Matcher matcher) {
        return GrokPattern.create(matcher.group(1), matcher.group(2));
    }

    private static /* synthetic */ boolean lambda$readGrokPatterns$0(String s) {
        return !s.startsWith("#") && !s.isEmpty();
    }
}

