/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.activities;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class Activity {
    private final Class<?> caller;
    private String message;

    public Activity(Class<?> caller) {
        this.caller = Objects.requireNonNull(caller);
    }

    public Activity(String content, Class<?> caller) {
        this.message = Objects.requireNonNull(content);
        this.caller = Objects.requireNonNull(caller);
    }

    public void setMessage(String message) {
        this.message = Objects.requireNonNull(message);
    }

    public String getMessage() {
        return this.message;
    }

    public Class<?> getCaller() {
        return this.caller;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals(this.caller, activity.caller) && Objects.equals(this.message, activity.message);
    }

    public int hashCode() {
        return Objects.hash(this.caller, this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("caller", this.caller).add("message", (Object)this.message).toString();
    }
}

