/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.cluster.jest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.http.JestHttpClient;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.QueryParsingException;

public class JestUtils {
    private JestUtils() {
    }

    public static <T extends JestResult> T execute(JestClient client, RequestConfig requestConfig, Action<T> request, Supplier<String> errorMessage) {
        JestResult result;
        try {
            result = client instanceof JestHttpClient ? ((JestHttpClient)client).execute(request, requestConfig) : client.execute(request);
        }
        catch (IOException e) {
            throw new ElasticsearchException(errorMessage.get(), (Throwable)e);
        }
        if (result.isSucceeded()) {
            return (T)result;
        }
        throw JestUtils.specificException(errorMessage, result.getJsonObject());
    }

    public static <T extends JestResult> T execute(JestClient client, Action<T> request, Supplier<String> errorMessage) {
        return JestUtils.execute(client, null, request, errorMessage);
    }

    private static ElasticsearchException specificException(Supplier<String> errorMessage, JsonNode jsonObject) {
        List<JsonNode> rootCauses = JestUtils.extractRootCauses(jsonObject);
        List<String> reasons = JestUtils.extractReasons(rootCauses);
        for (JsonNode rootCause : rootCauses) {
            String type = rootCause.path("type").asText(null);
            if (type == null) continue;
            switch (type) {
                case "query_parsing_exception": {
                    return JestUtils.buildQueryParsingException(errorMessage, rootCause, reasons);
                }
                case "index_not_found_exception": {
                    String indexName = rootCause.path("resource.id").asText();
                    return JestUtils.buildIndexNotFoundException(errorMessage, indexName);
                }
                case "illegal_argument_exception": {
                    String reason = rootCause.path("reason").asText();
                    if (!reason.startsWith("Expected numeric type on field")) break;
                    return JestUtils.buildFieldTypeException(errorMessage, reason);
                }
            }
        }
        if (reasons.isEmpty()) {
            return new ElasticsearchException(errorMessage.get(), Collections.singletonList(jsonObject.toString()));
        }
        return new ElasticsearchException(errorMessage.get(), reasons);
    }

    private static FieldTypeException buildFieldTypeException(Supplier<String> errorMessage, String reason) {
        return new FieldTypeException(errorMessage.get(), reason);
    }

    private static List<String> extractReasons(List<JsonNode> rootCauses) {
        return rootCauses.stream().map(rootCause -> rootCause.path("reason").asText(null)).collect(Collectors.toList());
    }

    private static List<JsonNode> extractRootCauses(JsonNode jsonObject) {
        return ImmutableList.copyOf((Iterator)jsonObject.path("error").path("root_cause").iterator());
    }

    private static QueryParsingException buildQueryParsingException(Supplier<String> errorMessage, JsonNode rootCause, List<String> reasons) {
        JsonNode lineJson = rootCause.path("line");
        Integer line = lineJson.isInt() ? Integer.valueOf(lineJson.asInt()) : null;
        JsonNode columnJson = rootCause.path("col");
        Integer column = columnJson.isInt() ? Integer.valueOf(columnJson.asInt()) : null;
        String index = rootCause.path("index").asText(null);
        return new QueryParsingException(errorMessage.get(), line, column, index, reasons);
    }

    private static IndexNotFoundException buildIndexNotFoundException(Supplier<String> errorMessage, String index) {
        return new IndexNotFoundException(errorMessage.get(), Collections.singletonList("Index not found for query: " + index + ". Try recalculating your index ranges."));
    }
}

