/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import javax.inject.Inject;
import org.graylog2.cluster.LdapGroupMappingMigrationState;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapGroupMappingMigration
extends Periodical {
    private static final Logger log = LoggerFactory.getLogger(LdapGroupMappingMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final LdapSettingsService ldapSettingsService;

    @Inject
    public LdapGroupMappingMigration(ClusterConfigService clusterConfigService, LdapSettingsService ldapSettingsService) {
        this.clusterConfigService = clusterConfigService;
        this.ldapSettingsService = ldapSettingsService;
    }

    @Override
    public void doRun() {
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        if (ldapSettings != null) {
            ldapSettings.setGroupMapping(ldapSettings.getGroupMapping());
            try {
                this.ldapSettingsService.save(ldapSettings);
                this.clusterConfigService.write(LdapGroupMappingMigrationState.create(true));
                log.info("Migrated LDAP group mapping format");
            }
            catch (ValidationException e) {
                log.error("Unable to save migrated LDAP settings!", (Throwable)e);
            }
        }
    }

    @Override
    public boolean startOnThisNode() {
        LdapGroupMappingMigrationState migrationState = this.clusterConfigService.getOrDefault(LdapGroupMappingMigrationState.class, LdapGroupMappingMigrationState.create(false));
        return !migrationState.migrationDone();
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

