/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.graylog2.Configuration;
import org.graylog2.rest.RestTools;

@Path(value="/config.js")
public class AppConfigResource {
    private final Configuration configuration;
    private final Engine templateEngine;

    @Inject
    public AppConfigResource(Configuration configuration, Engine templateEngine) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
    }

    @GET
    @Produces(value={"application/javascript"})
    public String get(@Context HttpHeaders headers) {
        String template;
        URL templateUrl = this.getClass().getResource("/web-interface/config.js.template");
        try {
            template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read AppConfig template while generating web interface configuration: ", e);
        }
        ImmutableMap model = ImmutableMap.of((Object)"rootTimeZone", (Object)this.configuration.getRootTimeZone(), (Object)"serverUri", (Object)RestTools.buildEndpointUri(headers, this.configuration.getWebEndpointUri()), (Object)"appPathPrefix", (Object)this.configuration.getWebPrefix());
        return this.templateEngine.transform(template, (Map)model);
    }
}

