/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.Configuration;
import org.graylog2.web.PluginAssets;

@Singleton
public class IndexHtmlGenerator {
    private static final String title = "Graylog Web Interface";
    private final String content;

    @Inject
    public IndexHtmlGenerator(PluginAssets pluginAssets, Configuration configuration, Engine templateEngine) throws IOException {
        URL templateUrl = this.getClass().getResource("/web-interface/index.html.template");
        String template = Resources.toString((URL)templateUrl, (Charset)StandardCharsets.UTF_8);
        ImmutableMap model = ImmutableMap.builder().put((Object)"title", (Object)title).put((Object)"cssFiles", pluginAssets.cssFiles()).put((Object)"jsFiles", pluginAssets.sortedJsFiles()).put((Object)"appPrefix", (Object)configuration.getWebPrefix()).build();
        this.content = Objects.requireNonNull(templateEngine, "templateEngine").transform(template, (Map)model);
    }

    public String get() {
        return this.content;
    }
}

