/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.utilities;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.utilities.AutoValue_FileInfo;

@AutoValue
public abstract class FileInfo {
    @Nullable
    public abstract Object key();

    public abstract long size();

    @Nullable
    public abstract FileTime modificationTime();

    public abstract Path path();

    public static Builder builder() {
        return new AutoValue_FileInfo.Builder();
    }

    @NotNull
    public static FileInfo forPath(Path path) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return FileInfo.builder().path(path).key(attributes.fileKey()).size(attributes.size()).modificationTime(attributes.lastModifiedTime()).build();
        }
        catch (IOException e) {
            return FileInfo.builder().key(null).modificationTime(null).size(-1L).path(path).build();
        }
    }

    @NotNull
    public Change checkForChange() {
        FileInfo newFileInfo = FileInfo.forPath(this.path());
        if (newFileInfo.equals(this)) {
            return Change.none();
        }
        return new Change(newFileInfo);
    }

    public static class Change {
        private static final Change NONE = new Change(null);
        private final FileInfo info;

        public Change(FileInfo info) {
            this.info = info;
        }

        public static Change none() {
            return NONE;
        }

        public boolean isChanged() {
            return this.info != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            return this.info.equals(change.info);
        }

        public int hashCode() {
            return Objects.hash(this.info);
        }

        @Nullable
        public FileInfo fileInfo() {
            return this.info;
        }
    }

    public static abstract class Builder {
        public abstract Builder key(@Nullable Object var1);

        public abstract Builder size(long var1);

        public abstract Builder modificationTime(@Nullable FileTime var1);

        public abstract Builder path(Path var1);

        public abstract FileInfo build();
    }
}

