/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.graylog2.shared.users.Role;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InMemoryRolePermissionResolver
implements RolePermissionResolver {
    private static final Logger log = LoggerFactory.getLogger(InMemoryRolePermissionResolver.class);
    private final RoleService roleService;
    private final AtomicReference<ImmutableMap<String, Role>> idToRoleIndex = new AtomicReference<ImmutableMap>(ImmutableMap.of());

    @Inject
    public InMemoryRolePermissionResolver(RoleService roleService, @Named(value="daemonScheduler") ScheduledExecutorService daemonScheduler) {
        this.roleService = roleService;
        RoleUpdater updater = new RoleUpdater();
        updater.run();
        daemonScheduler.scheduleAtFixedRate(updater, 1L, 1L, TimeUnit.SECONDS);
    }

    public Collection<Permission> resolvePermissionsInRole(String roleId) {
        Set<String> permissions = this.resolveStringPermission(roleId);
        return Sets.newHashSet((Iterable)Collections2.transform(permissions, (Function)new Function<String, Permission>(){

            @Nullable
            public Permission apply(@Nullable String input) {
                return new WildcardPermission(input);
            }
        }));
    }

    @Nonnull
    public Set<String> resolveStringPermission(String roleId) {
        ImmutableMap<String, Role> index = this.idToRoleIndex.get();
        Role role = (Role)index.get((Object)roleId);
        if (role == null) {
            log.debug("Unknown role {}, cannot resolve permissions.", (Object)roleId);
            return Collections.emptySet();
        }
        Set<String> permissions = role.getPermissions();
        if (permissions == null) {
            log.debug("Role {} has no permissions assigned, cannot resolve permissions.", (Object)roleId);
            return Collections.emptySet();
        }
        return permissions;
    }

    private class RoleUpdater
    implements Runnable {
        private RoleUpdater() {
        }

        @Override
        public void run() {
            try {
                Map<String, Role> index = InMemoryRolePermissionResolver.this.roleService.loadAllIdMap();
                InMemoryRolePermissionResolver.this.idToRoleIndex.set(ImmutableMap.copyOf(index));
            }
            catch (Exception e) {
                log.error("Could not find roles collection, no user roles updated.", (Throwable)e);
            }
        }
    }
}

