/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.validators;

import com.google.common.base.Preconditions;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.database.validators.ValidationResult;

public class LimitedOptionalStringValidator
extends OptionalStringValidator {
    private final int maxLength;

    public LimitedOptionalStringValidator(int maxLength) {
        Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be greater than 0");
        this.maxLength = maxLength;
    }

    @Override
    public ValidationResult validate(Object value) {
        String sValue;
        ValidationResult result = super.validate(value);
        if (result instanceof ValidationResult.ValidationPassed && (sValue = (String)value) != null && sValue.length() > this.maxLength) {
            result = new ValidationResult.ValidationFailed("Value is longer than " + this.maxLength + " characters!");
        }
        return result;
    }
}

