/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.ClearScroll;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollResult
extends IndexQueryResult {
    private static final Logger LOG = LoggerFactory.getLogger(ScrollResult.class);
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final String DEFAULT_SCROLL = "1m";
    private final JestClient jestClient;
    private final ObjectMapper objectMapper;
    private SearchResult initialResult;
    private final String scroll;
    private final List<String> fields;
    private final String queryHash;
    private final long totalHits;
    private String scrollId;
    private int chunkId = 0;

    @AssistedInject
    public ScrollResult(JestClient jestClient, ObjectMapper objectMapper, @Assisted SearchResult initialResult, @Assisted(value="query") String query, @Assisted List<String> fields) {
        this(jestClient, objectMapper, initialResult, query, DEFAULT_SCROLL, fields);
    }

    @AssistedInject
    public ScrollResult(JestClient jestClient, ObjectMapper objectMapper, @Assisted SearchResult initialResult, @Assisted(value="query") String query, @Assisted(value="scroll") String scroll, @Assisted List<String> fields) {
        super(query, null, initialResult.getJsonObject().path("took").asLong());
        this.jestClient = jestClient;
        this.objectMapper = objectMapper;
        this.initialResult = initialResult;
        this.scroll = scroll;
        this.fields = fields;
        this.totalHits = initialResult.getTotal();
        this.scrollId = this.getScrollIdFromResult((JestResult)initialResult);
        Md5Hash md5Hash = new Md5Hash((Object)this.getOriginalQuery());
        this.queryHash = md5Hash.toHex();
        LOG.debug("[{}] Starting scroll request for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
    }

    public ScrollChunk nextChunk() throws IOException {
        List<ResultMessage> hits;
        JestResult search;
        if (this.initialResult == null) {
            search = this.getNextScrollResult();
            hits = StreamSupport.stream(search.getJsonObject().path("hits").path("hits").spliterator(), false).map(hit -> ResultMessage.parseFromSource(hit.path("_id").asText(), hit.path("_index").asText(), (Map)this.objectMapper.convertValue((Object)hit.get("_source"), MAP_TYPE_REFERENCE))).collect(Collectors.toList());
        } else {
            search = this.initialResult;
            hits = this.initialResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source)).collect(Collectors.toList());
            this.initialResult = null;
        }
        if (hits.size() == 0) {
            LOG.debug("[{}] Reached end of scroll results.", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        LOG.debug("[{}][{}] New scroll id {}, number of hits in chunk: {}", new Object[]{this.queryHash, this.chunkId, this.getScrollIdFromResult(search), hits.size()});
        this.scrollId = this.getScrollIdFromResult(search);
        return new ScrollChunk(hits, this.fields, this.chunkId++);
    }

    private String getScrollIdFromResult(JestResult result) {
        return result.getJsonObject().path("_scroll_id").asText();
    }

    private JestResult getNextScrollResult() throws IOException {
        SearchScroll.Builder searchBuilder = new SearchScroll.Builder(this.scrollId, this.scroll);
        return this.jestClient.execute((Action)searchBuilder.build());
    }

    public String getQueryHash() {
        return this.queryHash;
    }

    public long totalHits() {
        return this.totalHits;
    }

    public void cancel() throws IOException {
        ClearScroll.Builder clearScrollBuilder = new ClearScroll.Builder().addScrollId(this.scrollId);
        JestResult result = this.jestClient.execute((Action)clearScrollBuilder.build());
        LOG.debug("[{}] clearScroll for query successful: {}", (Object)this.queryHash, (Object)result.isSucceeded());
    }

    public class ScrollChunk {
        private final List<ResultMessage> resultMessages;
        private List<String> fields;
        private int chunkNumber;

        ScrollChunk(List<ResultMessage> hits, List<String> fields, int chunkId) {
            this.resultMessages = hits;
            this.fields = fields;
            this.chunkNumber = chunkId;
        }

        public List<String> getFields() {
            return this.fields;
        }

        public int getChunkNumber() {
            return this.chunkNumber;
        }

        public boolean isFirstChunk() {
            return this.getChunkNumber() == 0;
        }

        public List<ResultMessage> getMessages() {
            return this.resultMessages;
        }
    }

    public static interface Factory {
        public ScrollResult create(SearchResult var1, @Assisted(value="query") String var2, List<String> var3);

        public ScrollResult create(SearchResult var1, @Assisted(value="query") String var2, @Assisted(value="scroll") String var3, List<String> var4);
    }
}

