/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.lookup.dto.LookupTableDto;
import org.graylog2.rest.models.PaginatedList;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class DBLookupTableService {
    private final JacksonDBCollection<LookupTableDto, ObjectId> db;

    @Inject
    public DBLookupTableService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("lut_tables"), LookupTableDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    public Optional<LookupTableDto> get(String idOrName) {
        try {
            return Optional.ofNullable((LookupTableDto)this.db.findOneById((Object)new ObjectId(idOrName)));
        }
        catch (IllegalArgumentException e) {
            return Optional.ofNullable((LookupTableDto)this.db.findOne(DBQuery.is((String)"name", (Object)idOrName)));
        }
    }

    public LookupTableDto save(LookupTableDto table) {
        WriteResult save = this.db.save((Object)table);
        return (LookupTableDto)save.getSavedObject();
    }

    public Collection<LookupTableDto> findAll() {
        return this.asImmutableList((Iterator<? extends LookupTableDto>)this.db.find());
    }

    public PaginatedList<LookupTableDto> findPaginated(DBQuery.Query query, DBSort.SortBuilder sort, int page, int perPage) {
        DBCursor cursor = this.db.find(query).sort((DBObject)sort).limit(perPage).skip(perPage * Math.max(0, page - 1));
        return new PaginatedList<LookupTableDto>((List<LookupTableDto>)this.asImmutableList((Iterator<? extends LookupTableDto>)cursor), cursor.count(), page, perPage);
    }

    public Collection<LookupTableDto> findByCacheIds(Collection<String> cacheIds) {
        return this.asImmutableList((Iterator<? extends LookupTableDto>)this.db.find(DBQuery.in((String)"cache", (Collection)cacheIds.stream().map(ObjectId::new).collect(Collectors.toList()))));
    }

    public Collection<LookupTableDto> findByDataAdapterIds(Collection<String> dataAdapterIds) {
        return this.asImmutableList((Iterator<? extends LookupTableDto>)this.db.find(DBQuery.in((String)"data_adapter", (Collection)dataAdapterIds.stream().map(ObjectId::new).collect(Collectors.toList()))));
    }

    private ImmutableList<LookupTableDto> asImmutableList(Iterator<? extends LookupTableDto> cursor) {
        return ImmutableList.copyOf(cursor);
    }

    public void delete(String idOrName) {
        try {
            this.db.removeById((Object)new ObjectId(idOrName));
        }
        catch (IllegalArgumentException e) {
            this.db.remove(DBQuery.is((String)"name", (Object)idOrName));
        }
    }

    public void forEach(Consumer<? super LookupTableDto> action) {
        this.db.find().forEachRemaining(action);
    }
}

