/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alarmcallbacks;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationImpl;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackListSummary;
import org.graylog2.rest.models.alarmcallbacks.AlarmCallbackSummary;
import org.graylog2.rest.models.alarmcallbacks.requests.CreateAlarmCallbackRequest;
import org.graylog2.rest.models.alarmcallbacks.responses.AvailableAlarmCallbacksResponse;
import org.graylog2.rest.models.alarmcallbacks.responses.CreateAlarmCallbackResponse;
import org.graylog2.rest.resources.alarmcallbacks.AlarmCallbacksResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.graylog2.utilities.ConfigurationMapConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Stream/AlarmCallbacks", description="Manage stream alarm callbacks")
@Path(value="/streams/{streamid}/alarmcallbacks")
public class StreamAlarmCallbackResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAlarmCallbackResource.class);
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final StreamService streamService;
    private final AlarmCallbackFactory alarmCallbackFactory;
    private final AlarmCallbacksResource alarmCallbacksResource;

    @Inject
    public StreamAlarmCallbackResource(AlarmCallbackConfigurationService alarmCallbackConfigurationService, StreamService streamService, AlarmCallbackFactory alarmCallbackFactory, AlarmCallbacksResource alarmCallbacksResource) {
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.streamService = streamService;
        this.alarmCallbackFactory = alarmCallbackFactory;
        this.alarmCallbacksResource = alarmCallbacksResource;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all alarm callbacks for this stream")
    @Produces(value={"application/json"})
    public AlarmCallbackListSummary get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        ArrayList alarmCallbacks = Lists.newArrayList();
        for (AlarmCallbackConfiguration callback : this.alarmCallbackConfigurationService.getForStream(stream)) {
            alarmCallbacks.add(AlarmCallbackSummary.create(callback.getId(), callback.getStreamId(), callback.getType(), callback.getTitle(), callback.getConfiguration(), callback.getCreatedAt(), callback.getCreatorUserId()));
        }
        return AlarmCallbackListSummary.create(alarmCallbacks);
    }

    @GET
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Get a single specified alarm callback for this stream")
    @Produces(value={"application/json"})
    public AlarmCallbackSummary get(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", value="The alarm callback id we are getting", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:read", streamid);
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new NotFoundException("Couldn't find alarm callback " + alarmCallbackId + " in for steam " + streamid);
        }
        return AlarmCallbackSummary.create(result.getId(), result.getStreamId(), result.getType(), result.getTitle(), result.getConfiguration(), result.getCreatedAt(), result.getCreatorUserId());
    }

    @POST
    @Timed
    @ApiOperation(value="Create an alarm callback", response=CreateAlarmCallbackResponse.class)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:alarm_callback:create")
    public Response create(@ApiParam(name="streamid", value="The stream id this new alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="JSON body", required=true) CreateAlarmCallbackRequest originalCr) throws org.graylog2.database.NotFoundException {
        String id;
        this.checkPermission("streams:edit", streamid);
        CreateAlarmCallbackRequest cr = CreateAlarmCallbackRequest.create(originalCr.type(), originalCr.title(), this.convertConfigurationValues(originalCr));
        AlarmCallbackConfiguration alarmCallbackConfiguration = this.alarmCallbackConfigurationService.create(streamid, cr, this.getCurrentUser().getName());
        try {
            this.alarmCallbackFactory.create(alarmCallbackConfiguration).checkConfiguration();
            id = this.alarmCallbackConfigurationService.save(alarmCallbackConfiguration);
        }
        catch (AlarmCallbackConfigurationException | ConfigurationException | ValidationException e) {
            LOG.error("Invalid alarm callback configuration.", (Throwable)e);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid alarm callback type.", (Throwable)e);
            throw new BadRequestException("Invalid alarm callback type.", (Throwable)e);
        }
        URI alarmCallbackUri = this.getUriBuilderToSelf().path(StreamAlarmCallbackResource.class).path("{alarmCallbackId}").build(new Object[]{streamid, id});
        return Response.created((URI)alarmCallbackUri).entity((Object)CreateAlarmCallbackResponse.create(id)).build();
    }

    @GET
    @Path(value="/available")
    @Timed
    @ApiOperation(value="Get a list of all alarm callback types")
    @Produces(value={"application/json"})
    @Deprecated
    public AvailableAlarmCallbacksResponse available(@ApiParam(name="streamid", value="The id of the stream whose alarm callbacks we want.", required=true) @PathParam(value="streamid") String streamid) {
        this.checkPermission("streams:read", streamid);
        return this.alarmCallbacksResource.available();
    }

    @DELETE
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Delete an alarm callback")
    @ApiResponses(value={@ApiResponse(code=404, message="Alarm callback not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditEvent(type="server:alarm_callback:delete")
    public void delete(@ApiParam(name="streamid", value="The stream id this alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        AlarmCallbackConfiguration result = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (result == null || !result.getStreamId().equals(stream.getId())) {
            throw new NotFoundException("Couldn't find alarm callback " + alarmCallbackId + " in for steam " + streamid);
        }
        if (this.alarmCallbackConfigurationService.destroy(result) == 0) {
            String msg = "Couldn't remove alarm callback with ID " + result.getId();
            LOG.error(msg);
            throw new InternalServerErrorException(msg);
        }
    }

    @PUT
    @Path(value="/{alarmCallbackId}")
    @Timed
    @ApiOperation(value="Update an alarm callback")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:alarm_callback:update")
    public void update(@ApiParam(name="streamid", value="The stream id this alarm callback belongs to.", required=true) @PathParam(value="streamid") String streamid, @ApiParam(name="alarmCallbackId", required=true) @PathParam(value="alarmCallbackId") String alarmCallbackId, @ApiParam(name="JSON body", required=true) CreateAlarmCallbackRequest alarmCallbackRequest) throws org.graylog2.database.NotFoundException {
        this.checkPermission("streams:edit", streamid);
        AlarmCallbackConfiguration callbackConfiguration = this.alarmCallbackConfigurationService.load(alarmCallbackId);
        if (callbackConfiguration == null) {
            throw new org.graylog2.database.NotFoundException("Unable to find alarm callback configuration " + alarmCallbackId);
        }
        Map<String, Object> configuration = this.convertConfigurationValues(alarmCallbackRequest);
        AlarmCallbackConfigurationImpl updatedConfig = ((AlarmCallbackConfigurationImpl)callbackConfiguration).toBuilder().setTitle(alarmCallbackRequest.title()).setConfiguration(configuration).build();
        try {
            this.alarmCallbackFactory.create(updatedConfig).checkConfiguration();
            this.alarmCallbackConfigurationService.save(updatedConfig);
        }
        catch (AlarmCallbackConfigurationException | ConfigurationException | ValidationException e) {
            LOG.error("Invalid alarm callback configuration.", (Throwable)e);
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid alarm callback type.", (Throwable)e);
            throw new BadRequestException("Invalid alarm callback type.", (Throwable)e);
        }
    }

    private Map<String, Object> convertConfigurationValues(CreateAlarmCallbackRequest alarmCallbackRequest) {
        Map<String, Object> configuration;
        ConfigurationRequest requestedConfiguration;
        try {
            AlarmCallback alarmCallback = this.alarmCallbackFactory.create(alarmCallbackRequest.type());
            requestedConfiguration = alarmCallback.getRequestedConfiguration();
        }
        catch (ClassNotFoundException e) {
            throw new BadRequestException("Unable to load alarm callback of type " + alarmCallbackRequest.type(), (Throwable)e);
        }
        try {
            configuration = ConfigurationMapConverter.convertValues(alarmCallbackRequest.configuration(), requestedConfiguration);
        }
        catch (ValidationException e) {
            throw new BadRequestException("Invalid configuration map", (Throwable)e);
        }
        return configuration;
    }
}

