/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.lookup.adapters.$AutoValue_DnsLookupDataAdapter_Config;
import org.graylog2.lookup.adapters.dnslookup.ADnsAnswer;
import org.graylog2.lookup.adapters.dnslookup.DnsAnswer;
import org.graylog2.lookup.adapters.dnslookup.DnsClient;
import org.graylog2.lookup.adapters.dnslookup.DnsLookupType;
import org.graylog2.lookup.adapters.dnslookup.PtrDnsAnswer;
import org.graylog2.lookup.adapters.dnslookup.TxtDnsAnswer;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsLookupDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DnsLookupDataAdapter.class);
    public static final String NAME = "dnslookup";
    private static final Duration REFRESH_INTERVAL_DURATION = Duration.ZERO;
    private static final String A_RECORD_LABEL = "A";
    private static final String AAAA_RECORD_LABEL = "AAAA";
    private static final String ERROR_COUNTER = "errors";
    private static final String RESULTS_FIELD = "results";
    private static final String RAW_RESULTS_FIELD = "raw_results";
    private static final String TIMER_RESOLVE_DOMAIN_NAME = "resolveDomainNameTime";
    private static final String TIMER_REVERSE_LOOKUP = "reverseLookupTime";
    private static final String TIMER_TEXT_LOOKUP = "textLookupTime";
    private DnsClient dnsClient;
    private final Config config;
    private final Counter errorCounter;
    private final Timer resolveDomainNameTimer;
    private final Timer reverseLookupTimer;
    private final Timer textLookupTimer;

    @Inject
    public DnsLookupDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.errorCounter = metricRegistry.counter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{id, ERROR_COUNTER}));
        this.resolveDomainNameTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{id, TIMER_RESOLVE_DOMAIN_NAME}));
        this.reverseLookupTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{id, TIMER_REVERSE_LOOKUP}));
        this.textLookupTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{id, TIMER_TEXT_LOOKUP}));
    }

    @Override
    protected void doStart() {
        this.dnsClient = new DnsClient();
        this.dnsClient.start(this.config.serverIps(), this.config.requestTimeout());
    }

    @Override
    protected void doStop() {
        this.dnsClient.stop();
    }

    @Override
    public Duration refreshInterval() {
        return REFRESH_INTERVAL_DURATION;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected LookupResult doGet(Object key) {
        trimmedKey = StringUtils.trimToNull((String)key.toString());
        if (trimmedKey == null) {
            DnsLookupDataAdapter.LOG.debug("A blank key was supplied");
            return LookupResult.empty();
        }
        DnsLookupDataAdapter.LOG.debug("Beginning [{}] DNS resolution for key [{}]", (Object)this.config.lookupType(), (Object)trimmedKey);
        switch (1.$SwitchMap$org$graylog2$lookup$adapters$dnslookup$DnsLookupType[this.config.lookupType().ordinal()]) {
            case 1: {
                ignored = this.resolveDomainNameTimer.time();
                var5_8 = null;
                lookupResult = this.resolveIPv4AddressForHostname(trimmedKey);
                if (ignored == null) break;
                if (var5_8 == null) ** GOTO lbl20
                try {
                    ignored.close();
                }
                catch (Throwable var6_14) {
                    var5_8.addSuppressed(var6_14);
                }
                break;
lbl20:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_15) {
                    try {
                        var5_8 = var6_15;
                        throw var6_15;
                    }
                    catch (Throwable var7_24) {
                        if (ignored != null) {
                            if (var5_8 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var8_25) {
                                    var5_8.addSuppressed(var8_25);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var7_24;
                    }
                }
            }
            case 2: {
                ignored = this.resolveDomainNameTimer.time();
                var5_9 = null;
                lookupResult = this.resolveIPv6AddressForHostname(trimmedKey);
                if (ignored == null) break;
                if (var5_9 == null) ** GOTO lbl50
                try {
                    ignored.close();
                }
                catch (Throwable var6_16) {
                    var5_9.addSuppressed(var6_16);
                }
                break;
lbl50:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_17) {
                    try {
                        var5_9 = var6_17;
                        throw var6_17;
                    }
                    catch (Throwable var9_26) {
                        if (ignored != null) {
                            if (var5_9 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var10_27) {
                                    var5_9.addSuppressed(var10_27);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var9_26;
                    }
                }
            }
            case 3: {
                ignored = this.resolveDomainNameTimer.time();
                var5_10 = null;
                lookupResult = this.resolveAllAddressesForHostname(trimmedKey);
                if (ignored == null) break;
                if (var5_10 == null) ** GOTO lbl80
                try {
                    ignored.close();
                }
                catch (Throwable var6_18) {
                    var5_10.addSuppressed(var6_18);
                }
                break;
lbl80:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_19) {
                    try {
                        var5_10 = var6_19;
                        throw var6_19;
                    }
                    catch (Throwable var11_28) {
                        if (ignored != null) {
                            if (var5_10 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var12_29) {
                                    var5_10.addSuppressed(var12_29);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var11_28;
                    }
                }
            }
            case 4: {
                ignored = this.reverseLookupTimer.time();
                var5_11 = null;
                lookupResult = this.performReverseLookup(trimmedKey);
                if (ignored == null) break;
                if (var5_11 == null) ** GOTO lbl110
                try {
                    ignored.close();
                }
                catch (Throwable var6_20) {
                    var5_11.addSuppressed(var6_20);
                }
                break;
lbl110:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_21) {
                    try {
                        var5_11 = var6_21;
                        throw var6_21;
                    }
                    catch (Throwable var13_30) {
                        if (ignored != null) {
                            if (var5_11 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var14_31) {
                                    var5_11.addSuppressed(var14_31);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var13_30;
                    }
                }
            }
            case 5: {
                ignored = this.textLookupTimer.time();
                var5_12 = null;
                lookupResult = this.performTextLookup(trimmedKey);
                if (ignored == null) break;
                if (var5_12 == null) ** GOTO lbl140
                try {
                    ignored.close();
                }
                catch (Throwable var6_22) {
                    var5_12.addSuppressed(var6_22);
                }
                break;
lbl140:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_23) {
                    try {
                        var5_12 = var6_23;
                        throw var6_23;
                    }
                    catch (Throwable var15_32) {
                        if (ignored != null) {
                            if (var5_12 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var16_33) {
                                    var5_12.addSuppressed(var16_33);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var15_32;
                    }
                }
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "DnsLookupType [%s] is not supported", new Object[]{this.config.lookupType()}));
            }
        }
        DnsLookupDataAdapter.LOG.debug("[{}] DNS resolution complete for key [{}]. Response [{}]", new Object[]{this.config.lookupType(), trimmedKey, lookupResult});
        return lookupResult;
    }

    private LookupResult resolveIPv4AddressForHostname(Object key) {
        List<ADnsAnswer> aDnsAnswers;
        try {
            aDnsAnswers = this.dnsClient.resolveIPv4AddressForHostname(key.toString(), false);
        }
        catch (UnknownHostException e) {
            return LookupResult.empty();
        }
        catch (Exception e) {
            LOG.error("Could not resolve [{}] records for hostname [{}]. Cause [{}]", new Object[]{A_RECORD_LABEL, key, ExceptionUtils.getRootCauseMessage(e)});
            this.errorCounter.inc();
            return LookupResult.empty();
        }
        if (CollectionUtils.isNotEmpty(aDnsAnswers)) {
            return this.buildLookupResult(aDnsAnswers);
        }
        LOG.debug("Could not resolve [{}] records for hostname [{}].", (Object)A_RECORD_LABEL, key);
        return LookupResult.empty();
    }

    private LookupResult resolveIPv6AddressForHostname(Object key) {
        List<ADnsAnswer> aDnsAnswers;
        try {
            aDnsAnswers = this.dnsClient.resolveIPv6AddressForHostname(key.toString(), false);
        }
        catch (UnknownHostException e) {
            return LookupResult.empty();
        }
        catch (Exception e) {
            LOG.error("Could not resolve [{}] records for hostname [{}]. Cause [{}]", new Object[]{AAAA_RECORD_LABEL, key, ExceptionUtils.getRootCauseMessage(e)});
            this.errorCounter.inc();
            return LookupResult.empty();
        }
        if (CollectionUtils.isNotEmpty(aDnsAnswers)) {
            return this.buildLookupResult(aDnsAnswers);
        }
        LOG.debug("Could not resolve [{}] records for hostname [{}].", (Object)AAAA_RECORD_LABEL, key);
        return LookupResult.empty();
    }

    private LookupResult buildLookupResult(List<ADnsAnswer> aDnsAnswers) {
        String singleValue = aDnsAnswers.get(0).ipAddress();
        LookupResult.Builder builder = LookupResult.builder().single(singleValue).multiValue(Collections.singletonMap(RESULTS_FIELD, aDnsAnswers));
        this.assignMinimumTTL(aDnsAnswers, builder);
        return builder.build();
    }

    private LookupResult resolveAllAddressesForHostname(Object key) {
        try {
            String singleValue;
            List<Object> ip4Answers = new ArrayList();
            List<Object> ip6Answers = new ArrayList();
            try {
                ip4Answers = this.dnsClient.resolveIPv4AddressForHostname(key.toString(), true);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            try {
                ip6Answers = this.dnsClient.resolveIPv6AddressForHostname(key.toString(), true);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (CollectionUtils.isNotEmpty(ip4Answers)) {
                singleValue = ((ADnsAnswer)ip4Answers.get(0)).ipAddress();
            } else if (CollectionUtils.isNotEmpty(ip6Answers)) {
                singleValue = ((ADnsAnswer)ip6Answers.get(0)).ipAddress();
            } else {
                LOG.debug("Could not resolve [A/AAAA] records hostname [{}].", key);
                return LookupResult.empty();
            }
            LookupResult.Builder builder = LookupResult.builder();
            if (StringUtils.isNotBlank((CharSequence)singleValue)) {
                builder.single(singleValue);
            }
            ArrayList<Object> allAnswers = new ArrayList<Object>();
            allAnswers.addAll(ip4Answers);
            allAnswers.addAll(ip6Answers);
            if (CollectionUtils.isNotEmpty(allAnswers)) {
                builder.multiValue(Collections.singletonMap(RESULTS_FIELD, allAnswers));
            }
            this.assignMinimumTTL(allAnswers, builder);
            return builder.build();
        }
        catch (Exception e) {
            LOG.error("Could not resolve [A/AAAA] records for hostname [{}]. Cause [{}]", key, (Object)ExceptionUtils.getRootCauseMessage(e));
            this.errorCounter.inc();
            return LookupResult.empty();
        }
    }

    private LookupResult performReverseLookup(Object key) {
        PtrDnsAnswer dnsResponse;
        try {
            dnsResponse = this.dnsClient.reverseLookup(key.toString());
        }
        catch (Exception e) {
            LOG.error("Could not perform reverse DNS lookup for [{}]. Cause [{}]", key, (Object)ExceptionUtils.getRootCauseMessage(e));
            this.errorCounter.inc();
            return LookupResult.empty();
        }
        if (dnsResponse != null && !Strings.isNullOrEmpty((String)dnsResponse.fullDomain())) {
            LinkedHashMap<Object, Object> multiValueResults = new LinkedHashMap<Object, Object>();
            multiValueResults.put("domain", dnsResponse.domain());
            multiValueResults.put("full_domain", dnsResponse.fullDomain());
            multiValueResults.put("dns_ttl", dnsResponse.dnsTTL());
            LookupResult.Builder builder = LookupResult.builder().single(dnsResponse.fullDomain()).multiValue(multiValueResults);
            if (this.config.hasOverrideTTL()) {
                builder.cacheTTL(this.config.getCacheTTLOverrideMillis());
            } else {
                builder.cacheTTL(dnsResponse.dnsTTL() * 1000L);
            }
            return builder.build();
        }
        LOG.debug("Could not perform reverse lookup on IP address [{}]. No PTR record was found.", key);
        return LookupResult.empty();
    }

    private LookupResult performTextLookup(Object key) {
        List<TxtDnsAnswer> txtDnsAnswers;
        try {
            txtDnsAnswers = this.dnsClient.txtLookup(key.toString());
        }
        catch (Exception e) {
            LOG.error("Could not perform TXT DNS lookup for [{}]. Cause [{}]", key, (Object)ExceptionUtils.getRootCauseMessage(e));
            this.errorCounter.inc();
            return LookupResult.empty();
        }
        if (CollectionUtils.isNotEmpty(txtDnsAnswers)) {
            LookupResult.Builder builder = LookupResult.builder();
            builder.multiValue(Collections.singletonMap(RAW_RESULTS_FIELD, txtDnsAnswers));
            this.assignMinimumTTL(txtDnsAnswers, builder);
            return builder.build();
        }
        LOG.debug("Could not perform Text lookup on IP address [{}]. No TXT records were found.", key);
        return LookupResult.empty();
    }

    private void assignMinimumTTL(List<? extends DnsAnswer> dnsAnswers, LookupResult.Builder builder) {
        if (this.config.hasOverrideTTL()) {
            builder.cacheTTL(this.config.getCacheTTLOverrideMillis());
        } else {
            builder.cacheTTL(dnsAnswers.stream().map(DnsAnswer::dnsTTL).min(Comparator.comparing(Long::valueOf)).get() * 1000L);
        }
    }

    @Override
    public void set(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="dnslookup")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        private static final String FIELD_CACHE_TTL_OVERRIDE = "cache_ttl_override";
        private static final String FIELD_CACHE_TTL_OVERRIDE_ENABLED = "cache_ttl_override_enabled";
        private static final String FIELD_CACHE_TTL_OVERRIDE_UNIT = "cache_ttl_override_unit";
        private static final String FIELD_LOOKUP_TYPE = "lookup_type";
        private static final String FIELD_REQUEST_TIMEOUT = "request_timeout";
        private static final String FIELD_SERVER_IPS = "server_ips";
        private static final boolean DEFAULT_CACHE_TTL_OVERRIDE = false;
        private static final DnsLookupType DEFAULT_LOOKUP_TYPE = DnsLookupType.A;
        private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
        private static final String DEFAULT_SERVER_IP = "";

        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="lookup_type")
        public abstract DnsLookupType lookupType();

        @JsonProperty(value="server_ips")
        public abstract String serverIps();

        @JsonProperty(value="request_timeout")
        public abstract int requestTimeout();

        @JsonProperty(value="cache_ttl_override_enabled")
        public abstract boolean cacheTTLOverrideEnabled();

        @Nullable
        @JsonProperty(value="cache_ttl_override")
        public abstract Long cacheTTLOverride();

        @Nullable
        @JsonProperty(value="cache_ttl_override_unit")
        public abstract TimeUnit cacheTTLOverrideUnit();

        public static Builder builder() {
            return new $AutoValue_DnsLookupDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            if (StringUtils.isNotBlank((CharSequence)this.serverIps()) && !DnsClient.allIpAddressesValid(this.serverIps())) {
                errors.put((Object)FIELD_SERVER_IPS, (Object)"Invalid server IP address and/or port. Please enter one or more comma-separated IPv4 addresses with optional ports (eg. 192.168.1.1:5353, 192.168.1.244).");
            }
            if (this.requestTimeout() < 1) {
                errors.put((Object)FIELD_REQUEST_TIMEOUT, (Object)"Value cannot be smaller than 1");
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        private boolean hasOverrideTTL() {
            return this.cacheTTLOverride() != null && this.cacheTTLOverrideUnit() != null;
        }

        private Long getCacheTTLOverrideMillis() {
            if (!this.cacheTTLOverrideEnabled() || this.cacheTTLOverride() == null || this.cacheTTLOverrideUnit() == null) {
                return Long.MAX_VALUE;
            }
            return this.cacheTTLOverrideUnit().toMillis(this.cacheTTLOverride());
        }

        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return Config.builder().serverIps(Config.DEFAULT_SERVER_IP).lookupType(DnsLookupType.A).cacheTTLOverrideEnabled(false).requestTimeout(10000);
            }

            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="lookup_type")
            public abstract Builder lookupType(DnsLookupType var1);

            @JsonProperty(value="server_ips")
            public abstract Builder serverIps(String var1);

            @JsonProperty(value="request_timeout")
            public abstract Builder requestTimeout(int var1);

            @JsonProperty(value="cache_ttl_override_enabled")
            public abstract Builder cacheTTLOverrideEnabled(boolean var1);

            @JsonProperty(value="cache_ttl_override")
            public abstract Builder cacheTTLOverride(Long var1);

            @JsonProperty(value="cache_ttl_override_unit")
            public abstract Builder cacheTTLOverrideUnit(@Nullable TimeUnit var1);

            abstract Config autoBuild();

            public Config build() {
                return this.autoBuild();
            }
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(DnsLookupDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(DnsLookupDataAdapter.NAME).lookupType(Config.DEFAULT_LOOKUP_TYPE).serverIps("").cacheTTLOverrideEnabled(false).requestTimeout(10000).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<DnsLookupDataAdapter> {
        @Override
        public DnsLookupDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

