/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.caches;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.validation.constraints.Min;
import org.graylog2.lookup.caches.;
import org.graylog2.plugin.lookup.LookupCache;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;
import org.graylog2.plugin.lookup.LookupCacheKey;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaLookupCache
extends LookupCache {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaLookupCache.class);
    public static final String NAME = "guava_cache";
    private final Cache<LookupCacheKey, LookupResult> cache;

    @Inject
    public GuavaLookupCache(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupCacheConfiguration c, @Named(value="processbuffer_processors") int processorCount, MetricRegistry metricRegistry) {
        super(id, name, c, metricRegistry);
        Config config = (Config)c;
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.concurrencyLevel(processorCount).recordStats();
        builder.maximumSize((long)config.maxSize());
        if (config.expireAfterAccess() > 0L && config.expireAfterAccessUnit() != null) {
            builder.expireAfterAccess(config.expireAfterAccess(), config.expireAfterAccessUnit());
        }
        if (config.expireAfterWrite() > 0L && config.expireAfterWriteUnit() != null) {
            builder.expireAfterWrite(config.expireAfterWrite(), config.expireAfterWriteUnit());
        }
        this.cache = new InstrumentedCache<LookupCacheKey, LookupResult>(builder.build(), this);
    }

    @Override
    public long entryCount() {
        if (this.cache != null) {
            return this.cache.size();
        }
        return 0L;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LookupResult get(LookupCacheKey key, Callable<LookupResult> loader) {
        try (Timer.Context ignored = this.lookupTimer();){
            LookupResult lookupResult = (LookupResult)this.cache.get((Object)key, loader);
            return lookupResult;
        }
        catch (ExecutionException e) {
            LOG.warn("Loading value from data adapter failed for key {}, returning empty result", (Object)key, (Object)e);
            return LookupResult.empty();
        }
    }

    @Override
    public LookupResult getIfPresent(LookupCacheKey key) {
        LookupResult cacheEntry = (LookupResult)this.cache.getIfPresent((Object)key);
        if (cacheEntry == null) {
            return LookupResult.empty();
        }
        return cacheEntry;
    }

    @Override
    public void purge() {
        this.cache.invalidateAll();
    }

    @Override
    public void purge(LookupCacheKey purgeKey) {
        if (purgeKey.isPrefixOnly()) {
            this.cache.invalidateAll((Iterable)this.cache.asMap().keySet().stream().filter(lookupCacheKey -> purgeKey.prefix().equals(lookupCacheKey.prefix())).collect(Collectors.toSet()));
        } else {
            this.cache.invalidate((Object)purgeKey);
        }
    }

    private static class InstrumentedCache<K, V>
    implements Cache<K, V> {
        private final Cache<K, V> delegate;
        private final LookupCache cache;

        public InstrumentedCache(Cache<K, V> delegate, LookupCache cache) {
            this.delegate = delegate;
            this.cache = cache;
        }

        @Nullable
        public V getIfPresent(Object key) {
            return (V)this.delegate.getIfPresent(key);
        }

        public V get(K key, Callable<? extends V> loader) throws ExecutionException {
            Object value = this.delegate.getIfPresent(key);
            if (value == null) {
                try {
                    value = loader.call();
                    this.delegate.put(key, value);
                    this.cache.incrMissCount();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            } else {
                this.cache.incrHitCount();
            }
            this.cache.incrTotalCount();
            return (V)value;
        }

        public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
            return this.delegate.getAllPresent(keys);
        }

        public void put(K key, V value) {
            this.delegate.put(key, value);
        }

        public void putAll(Map<? extends K, ? extends V> m) {
            this.delegate.putAll(m);
        }

        public void invalidate(Object key) {
            this.delegate.invalidate(key);
        }

        public void invalidateAll(Iterable<?> keys) {
            this.delegate.invalidateAll(keys);
        }

        public void invalidateAll() {
            this.delegate.invalidateAll();
        }

        public long size() {
            return this.delegate.size();
        }

        public CacheStats stats() {
            return this.delegate.stats();
        }

        public ConcurrentMap<K, V> asMap() {
            return this.delegate.asMap();
        }

        public void cleanUp() {
            this.delegate.cleanUp();
        }
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=.AutoValue_GuavaLookupCache_Config.Builder.class)
    @JsonTypeName(value="guava_cache")
    @AutoValue
    public static abstract class Config
    implements LookupCacheConfiguration {
        @Min(value=0L)
        @JsonProperty(value="max_size")
        public abstract @Min(value=0L) int maxSize();

        @Min(value=0L)
        @JsonProperty(value="expire_after_access")
        public abstract @Min(value=0L) long expireAfterAccess();

        @Nullable
        @JsonProperty(value="expire_after_access_unit")
        public abstract TimeUnit expireAfterAccessUnit();

        @Min(value=0L)
        @JsonProperty(value="expire_after_write")
        public abstract @Min(value=0L) long expireAfterWrite();

        @Nullable
        @JsonProperty(value="expire_after_write_unit")
        public abstract TimeUnit expireAfterWriteUnit();

        public static Builder builder() {
            return new .AutoValue_GuavaLookupCache_Config.Builder();
        }

        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="max_size")
            public abstract Builder maxSize(int var1);

            @JsonProperty(value="expire_after_access")
            public abstract Builder expireAfterAccess(long var1);

            @JsonProperty(value="expire_after_access_unit")
            public abstract Builder expireAfterAccessUnit(@Nullable TimeUnit var1);

            @JsonProperty(value="expire_after_write")
            public abstract Builder expireAfterWrite(long var1);

            @JsonProperty(value="expire_after_write_unit")
            public abstract Builder expireAfterWriteUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupCache.Descriptor<Config> {
        public Descriptor() {
            super(GuavaLookupCache.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(GuavaLookupCache.NAME).maxSize(1000).expireAfterAccess(60L).expireAfterAccessUnit(TimeUnit.SECONDS).expireAfterWrite(0L).build();
        }
    }

    public static interface Factory
    extends LookupCache.Factory {
        public GuavaLookupCache create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupCacheConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

