/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.filter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.graylog2.Configuration;
import org.graylog2.web.IndexHtmlGenerator;

@Priority(value=4000)
public class WebAppNotFoundResponseFilter
implements ContainerResponseFilter {
    private final String webAppPrefix;
    private final IndexHtmlGenerator indexHtmlGenerator;

    @Inject
    public WebAppNotFoundResponseFilter(Configuration configuration, IndexHtmlGenerator indexHtmlGenerator) {
        this.webAppPrefix = configuration.getWebListenUri().getPath();
        this.indexHtmlGenerator = indexHtmlGenerator;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Response.StatusType responseStatus = responseContext.getStatusInfo();
        String requestPath = requestContext.getUriInfo().getAbsolutePath().getPath();
        List acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
        boolean acceptsHtml = acceptableMediaTypes.stream().anyMatch(mediaType -> mediaType.isCompatible(MediaType.TEXT_HTML_TYPE) || mediaType.isCompatible(MediaType.APPLICATION_XHTML_XML_TYPE));
        boolean isGetRequest = "get".equalsIgnoreCase(requestContext.getMethod());
        if (isGetRequest && responseStatus == Response.Status.NOT_FOUND && acceptsHtml && requestPath.startsWith(this.webAppPrefix)) {
            String entity = this.indexHtmlGenerator.get();
            responseContext.setStatusInfo((Response.StatusType)Response.Status.OK);
            responseContext.setEntity((Object)entity, new Annotation[0], MediaType.TEXT_HTML_TYPE);
            responseContext.getHeaders().putSingle((Object)"X-UA-Compatible", (Object)"IE=edge");
        }
    }
}

