/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.jobs;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.system.SystemJobSummary;
import org.graylog2.rest.models.system.jobs.requests.TriggerRequest;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.jobs.NoSuchJobException;
import org.graylog2.system.jobs.SystemJob;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobFactory;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Jobs", description="System Jobs")
@Path(value="/system/jobs")
public class SystemJobResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SystemJobResource.class);
    private final SystemJobFactory systemJobFactory;
    private final SystemJobManager systemJobManager;
    private final NodeId nodeId;

    @Inject
    public SystemJobResource(SystemJobFactory systemJobFactory, SystemJobManager systemJobManager, NodeId nodeId) {
        this.systemJobFactory = systemJobFactory;
        this.systemJobManager = systemJobManager;
        this.nodeId = nodeId;
    }

    @GET
    @Timed
    @ApiOperation(value="List currently running jobs")
    @Produces(value={"application/json"})
    public Map<String, List<SystemJobSummary>> list() {
        ArrayList jobs = Lists.newArrayListWithCapacity((int)this.systemJobManager.getRunningJobs().size());
        for (Map.Entry<String, SystemJob> entry : this.systemJobManager.getRunningJobs().entrySet()) {
            if (!this.isPermitted("systemjobs:read", entry.getKey())) continue;
            SystemJob systemJob = entry.getValue();
            jobs.add(SystemJobSummary.create(UUID.fromString(systemJob.getId()), systemJob.getDescription(), systemJob.getClassName(), systemJob.getInfo(), this.nodeId.toString(), systemJob.getStartedAt(), systemJob.getProgress(), systemJob.isCancelable(), systemJob.providesProgress()));
        }
        return ImmutableMap.of((Object)"jobs", (Object)jobs);
    }

    @GET
    @Timed
    @Path(value="/{jobId}")
    @ApiOperation(value="Get information of a specific currently running job")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="Job not found.")})
    public SystemJobSummary get(@ApiParam(name="jobId", required=true) @PathParam(value="jobId") @NotEmpty String jobId) {
        this.checkPermission("systemjobs:read", jobId);
        SystemJob systemJob = this.systemJobManager.getRunningJobs().get(jobId);
        if (systemJob == null) {
            throw new NotFoundException("No system job with ID <" + jobId + "> found");
        }
        return SystemJobSummary.create(UUID.fromString(systemJob.getId()), systemJob.getDescription(), systemJob.getClassName(), systemJob.getInfo(), this.nodeId.toString(), systemJob.getStartedAt(), systemJob.getProgress(), systemJob.isCancelable(), systemJob.providesProgress());
    }

    @POST
    @Timed
    @ApiOperation(value="Trigger new job")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=202, message="Job accepted."), @ApiResponse(code=400, message="There is no such systemjob type."), @ApiResponse(code=403, message="Maximum concurrency level of this systemjob type reached.")})
    @AuditEvent(type="server:system_job:start")
    public Response trigger(@ApiParam(name="JSON body", required=true) @Valid @NotNull TriggerRequest tr) {
        SystemJob job;
        this.checkPermission("systemjobs:create", tr.jobName());
        try {
            job = this.systemJobFactory.build(tr.jobName());
        }
        catch (NoSuchJobException e) {
            LOG.error("Such a system job type does not exist. Returning HTTP 400.");
            throw new BadRequestException((Throwable)e);
        }
        try {
            this.systemJobManager.submit(job);
        }
        catch (SystemJobConcurrencyException e) {
            LOG.error("Maximum concurrency level of this job reached. ", (Throwable)e);
            throw new ForbiddenException("Maximum concurrency level of this job reached", (Throwable)e);
        }
        return Response.accepted().entity((Object)ImmutableMap.of((Object)"system_job_id", (Object)job.getId())).build();
    }

    @DELETE
    @Timed
    @Path(value="/{jobId}")
    @ApiOperation(value="Cancel running job")
    @Produces(value={"application/json"})
    @AuditEvent(type="server:system_job:stop")
    public SystemJobSummary cancel(@ApiParam(name="jobId", required=true) @PathParam(value="jobId") @NotEmpty String jobId) {
        SystemJob systemJob = this.systemJobManager.getRunningJobs().get(jobId);
        if (systemJob == null) {
            throw new NotFoundException("No system job with ID <" + jobId + "> found");
        }
        this.checkPermission("systemjobs:delete", systemJob.getClassName());
        if (!systemJob.isCancelable()) {
            throw new ForbiddenException("System job with ID <" + jobId + "> cannot be cancelled");
        }
        systemJob.requestCancel();
        return SystemJobSummary.create(UUID.fromString(systemJob.getId()), systemJob.getDescription(), systemJob.getClassName(), systemJob.getInfo(), this.nodeId.toString(), systemJob.getStartedAt(), systemJob.getProgress(), systemJob.isCancelable(), systemJob.providesProgress());
    }
}

