/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.map.search.MapDataSearchRequest;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_MapDataSearchRequest
extends MapDataSearchRequest {
    private final String query;
    private final TimeRange timerange;
    private final int limit;
    private final Set<String> fields;
    private final String streamId;

    private AutoValue_MapDataSearchRequest(String query, TimeRange timerange, int limit, Set<String> fields, @Nullable String streamId) {
        this.query = query;
        this.timerange = timerange;
        this.limit = limit;
        this.fields = fields;
        this.streamId = streamId;
    }

    @Override
    @JsonProperty(value="query")
    public String query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="timerange")
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="fields")
    public Set<String> fields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="stream_id")
    @Nullable
    public String streamId() {
        return this.streamId;
    }

    public String toString() {
        return "MapDataSearchRequest{query=" + this.query + ", timerange=" + this.timerange + ", limit=" + this.limit + ", fields=" + this.fields + ", streamId=" + this.streamId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MapDataSearchRequest) {
            MapDataSearchRequest that = (MapDataSearchRequest)o;
            return this.query.equals(that.query()) && this.timerange.equals(that.timerange()) && this.limit == that.limit() && this.fields.equals(that.fields()) && (this.streamId == null ? that.streamId() == null : this.streamId.equals(that.streamId()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.query.hashCode();
        h *= 1000003;
        h ^= this.timerange.hashCode();
        h *= 1000003;
        h ^= this.limit;
        h *= 1000003;
        h ^= this.fields.hashCode();
        h *= 1000003;
        return h ^= this.streamId == null ? 0 : this.streamId.hashCode();
    }

    @Override
    public MapDataSearchRequest.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MapDataSearchRequest.Builder {
        private String query;
        private TimeRange timerange;
        private Integer limit;
        private Set<String> fields;
        private String streamId;

        Builder() {
        }

        private Builder(MapDataSearchRequest source) {
            this.query = source.query();
            this.timerange = source.timerange();
            this.limit = source.limit();
            this.fields = source.fields();
            this.streamId = source.streamId();
        }

        @Override
        public MapDataSearchRequest.Builder query(String query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public MapDataSearchRequest.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public MapDataSearchRequest.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public MapDataSearchRequest.Builder fields(Set<String> fields) {
            if (fields == null) {
                throw new NullPointerException("Null fields");
            }
            this.fields = fields;
            return this;
        }

        @Override
        public MapDataSearchRequest.Builder streamId(@Nullable String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public MapDataSearchRequest build() {
            String missing = "";
            if (this.query == null) {
                missing = missing + " query";
            }
            if (this.timerange == null) {
                missing = missing + " timerange";
            }
            if (this.limit == null) {
                missing = missing + " limit";
            }
            if (this.fields == null) {
                missing = missing + " fields";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MapDataSearchRequest(this.query, this.timerange, this.limit, this.fields, this.streamId);
        }
    }
}

