/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.Nullable;
import org.graylog.plugins.map.search.MapDataSearchResult;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.search.responses.TermsResult;

final class AutoValue_MapDataSearchResult
extends MapDataSearchResult {
    private final String query;
    private final TimeRange timerange;
    private final int limit;
    private final String streamId;
    private final Map<String, TermsResult> fields;

    private AutoValue_MapDataSearchResult(String query, TimeRange timerange, int limit, @Nullable String streamId, Map<String, TermsResult> fields) {
        this.query = query;
        this.timerange = timerange;
        this.limit = limit;
        this.streamId = streamId;
        this.fields = fields;
    }

    @Override
    @JsonProperty(value="query")
    public String query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="timerange")
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty(value="limit")
    public int limit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="stream_id")
    @Nullable
    public String streamId() {
        return this.streamId;
    }

    @Override
    @JsonProperty(value="fields")
    public Map<String, TermsResult> fields() {
        return this.fields;
    }

    public String toString() {
        return "MapDataSearchResult{query=" + this.query + ", timerange=" + this.timerange + ", limit=" + this.limit + ", streamId=" + this.streamId + ", fields=" + this.fields + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MapDataSearchResult) {
            MapDataSearchResult that = (MapDataSearchResult)o;
            return this.query.equals(that.query()) && this.timerange.equals(that.timerange()) && this.limit == that.limit() && (this.streamId == null ? that.streamId() == null : this.streamId.equals(that.streamId())) && this.fields.equals(that.fields());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.query.hashCode();
        h *= 1000003;
        h ^= this.timerange.hashCode();
        h *= 1000003;
        h ^= this.limit;
        h *= 1000003;
        h ^= this.streamId == null ? 0 : this.streamId.hashCode();
        h *= 1000003;
        return h ^= this.fields.hashCode();
    }

    @Override
    public MapDataSearchResult.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MapDataSearchResult.Builder {
        private String query;
        private TimeRange timerange;
        private Integer limit;
        private String streamId;
        private Map<String, TermsResult> fields;

        Builder() {
        }

        private Builder(MapDataSearchResult source) {
            this.query = source.query();
            this.timerange = source.timerange();
            this.limit = source.limit();
            this.streamId = source.streamId();
            this.fields = source.fields();
        }

        @Override
        public MapDataSearchResult.Builder query(String query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public MapDataSearchResult.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public MapDataSearchResult.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public MapDataSearchResult.Builder streamId(@Nullable String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public MapDataSearchResult.Builder fields(Map<String, TermsResult> fields) {
            if (fields == null) {
                throw new NullPointerException("Null fields");
            }
            this.fields = fields;
            return this;
        }

        @Override
        public MapDataSearchResult build() {
            String missing = "";
            if (this.query == null) {
                missing = missing + " query";
            }
            if (this.timerange == null) {
                missing = missing + " timerange";
            }
            if (this.limit == null) {
                missing = missing + " limit";
            }
            if (this.fields == null) {
                missing = missing + " fields";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MapDataSearchResult(this.query, this.timerange, this.limit, this.streamId, this.fields);
        }
    }
}

