/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.widget.strategy;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.graylog.plugins.map.widget.strategy.MapWidgetStrategyConfiguration;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.indexer.results.TermsResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class MapWidgetStrategy
implements WidgetStrategy {
    public final int MAX_RESULTS = 250;
    private final Searches searches;
    private final MapWidgetStrategyConfiguration configuration;

    @Inject
    public MapWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        this.searches = searches;
        this.configuration = MapWidgetStrategyConfiguration.create(config, timeRange);
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        String streamId = this.configuration.streamId();
        if (!Strings.isNullOrEmpty((String)streamId)) {
            filter = "streams:" + streamId;
        }
        TermsResult terms = this.searches.terms(this.configuration.field(), 250, this.configuration.query(), filter, this.configuration.timeRange());
        HashMap result = Maps.newHashMap();
        result.put("terms", terms.getTerms());
        result.put("total", terms.getTotal());
        result.put("other", terms.getOther());
        result.put("missing", terms.getMissing());
        return new ComputationResult(result, terms.tookMs());
    }

    public static interface Factory
    extends WidgetStrategy.Factory<MapWidgetStrategy> {
        @Override
        public MapWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

