/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.v9;

import com.google.auto.value.AutoValue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.graylog.plugins.netflow.v9.AutoValue_NetFlowV9Header;

@AutoValue
public abstract class NetFlowV9Header {
    public abstract int version();

    public abstract int count();

    public abstract long sysUptime();

    public abstract long unixSecs();

    public abstract long sequence();

    public abstract long sourceId();

    public static NetFlowV9Header create(int version, int count, long sysUptime, long unixSecs, long sequence, long sourceId) {
        return new AutoValue_NetFlowV9Header(version, count, sysUptime, unixSecs, sequence, sourceId);
    }

    public String prettyHexDump() {
        ByteBuf buffer = Unpooled.buffer((int)20);
        try {
            buffer.writeShort(this.version());
            buffer.writeShort(this.count());
            buffer.writeInt(Math.toIntExact(this.sysUptime()));
            buffer.writeInt(Math.toIntExact(this.unixSecs()));
            buffer.writeInt(Math.toIntExact(this.sequence()));
            buffer.writeInt(Math.toIntExact(this.sourceId()));
            String string = ByteBufUtil.prettyHexDump((ByteBuf)buffer);
            return string;
        }
        finally {
            ReferenceCountUtil.release((Object)buffer);
        }
    }
}

