/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog2.database.NotFoundException;

public class InMemoryPipelineService
implements PipelineService {
    private AtomicLong idGen = new AtomicLong(0L);
    private Map<String, PipelineDao> store = new MapMaker().makeMap();
    private Map<String, String> titleToId = new MapMaker().makeMap();

    @Override
    public PipelineDao save(PipelineDao pipeline) {
        PipelineDao toSave;
        PipelineDao pipelineDao = toSave = pipeline.id() != null ? pipeline : pipeline.toBuilder().id(this.createId()).build();
        if (this.titleToId.containsKey(toSave.title()) && !this.titleToId.get(toSave.title()).equals(toSave.id())) {
            throw new IllegalArgumentException("Duplicate pipeline titles are not allowed: " + toSave.title());
        }
        this.titleToId.put(toSave.title(), toSave.id());
        this.store.put(toSave.id(), toSave);
        return toSave;
    }

    @Override
    public PipelineDao load(String id) throws NotFoundException {
        PipelineDao pipeline = this.store.get(id);
        if (pipeline == null) {
            throw new NotFoundException("No such pipeline with id " + id);
        }
        return pipeline;
    }

    @Override
    public Collection<PipelineDao> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public void delete(String id) {
        if (id == null) {
            return;
        }
        PipelineDao removed = this.store.remove(id);
        if (removed != null) {
            this.titleToId.remove(removed.title());
        }
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

