/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog2.database.NotFoundException;

public class InMemoryPipelineStreamConnectionsService
implements PipelineStreamConnectionsService {
    private AtomicLong idGen = new AtomicLong(0L);
    private Map<String, PipelineConnections> store = new MapMaker().makeMap();

    @Override
    public PipelineConnections save(PipelineConnections connections) {
        PipelineConnections toSave = connections.id() != null ? connections : connections.toBuilder().id(this.createId()).build();
        this.store.put(toSave.id(), toSave);
        return toSave;
    }

    @Override
    public PipelineConnections load(String streamId) throws NotFoundException {
        PipelineConnections connections = this.store.get(streamId);
        if (connections == null) {
            throw new NotFoundException("No such pipeline connections for stream " + streamId);
        }
        return connections;
    }

    @Override
    public Set<PipelineConnections> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public void delete(String streamId) {
        try {
            PipelineConnections connections = this.load(streamId);
            this.store.remove(connections.id());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

