/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.memory;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog2.database.NotFoundException;

public class InMemoryRuleService
implements RuleService {
    private AtomicLong idGen = new AtomicLong(0L);
    private Map<String, RuleDao> store = new MapMaker().makeMap();
    private Map<String, String> titleToId = new MapMaker().makeMap();

    @Override
    public RuleDao save(RuleDao rule) {
        RuleDao toSave;
        RuleDao ruleDao = toSave = rule.id() != null ? rule : rule.toBuilder().id(this.createId()).build();
        if (this.titleToId.containsKey(toSave.title()) && !this.titleToId.get(toSave.title()).equals(toSave.id())) {
            throw new IllegalArgumentException("Duplicate rule titles are not allowed: " + toSave.title());
        }
        this.titleToId.put(toSave.title(), toSave.id());
        this.store.put(toSave.id(), toSave);
        return toSave;
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        RuleDao rule = this.store.get(id);
        if (rule == null) {
            throw new NotFoundException("No such rule with id " + id);
        }
        return rule;
    }

    @Override
    public Collection<RuleDao> loadAll() {
        return ImmutableSet.copyOf(this.store.values());
    }

    @Override
    public void delete(String id) {
        if (id == null) {
            return;
        }
        RuleDao removed = this.store.remove(id);
        if (removed != null) {
            this.titleToId.remove(removed.title());
        }
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        HashSet needles = Sets.newHashSet(ruleNames);
        return this.store.values().stream().filter(ruleDao -> needles.contains(ruleDao.title())).collect(Collectors.toList());
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

