/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbRuleService
implements RuleService {
    private static final Logger log = LoggerFactory.getLogger(MongoDbRuleService.class);
    private static final String COLLECTION = "pipeline_processor_rules";
    private final JacksonDBCollection<RuleDao, String> dbCollection;

    @Inject
    public MongoDbRuleService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION), RuleDao.class, String.class, (ObjectMapper)mapper.get());
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"title"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public RuleDao save(RuleDao rule) {
        WriteResult save = this.dbCollection.save((Object)rule);
        return (RuleDao)save.getSavedObject();
    }

    @Override
    public RuleDao load(String id) throws NotFoundException {
        RuleDao rule = (RuleDao)this.dbCollection.findOneById((Object)id);
        if (rule == null) {
            throw new NotFoundException("No rule with id " + id);
        }
        return rule;
    }

    @Override
    public Collection<RuleDao> loadAll() {
        try {
            DBCursor ruleDaos = this.dbCollection.find().sort((DBObject)DBSort.asc((String)"title"));
            return ruleDaos.toArray();
        }
        catch (MongoException e) {
            log.error("Unable to load processing rules", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public void delete(String id) {
        WriteResult result = this.dbCollection.removeById((Object)id);
        if (result.getN() != 1) {
            log.error("Unable to delete rule {}", (Object)id);
        }
    }

    @Override
    public Collection<RuleDao> loadNamed(Collection<String> ruleNames) {
        try {
            DBCursor ruleDaos = this.dbCollection.find(DBQuery.in((String)"title", ruleNames));
            return Sets.newHashSet((Iterator)ruleDaos.iterator());
        }
        catch (MongoException e) {
            log.error("Unable to bulk load rules", (Throwable)e);
            return Collections.emptySet();
        }
    }
}

