/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class SetFields
extends AbstractFunction<Void> {
    public static final String NAME = "set_fields";
    private final ParameterDescriptor<Map, Map> fieldsParam = ParameterDescriptor.type("fields", Map.class).description("The map of new fields to set").build();
    private final ParameterDescriptor<String, String> prefixParam = ParameterDescriptor.string("prefix").optional().description("The prefix for the field names").build();
    private final ParameterDescriptor<String, String> suffixParam = ParameterDescriptor.string("suffix").optional().description("The suffix for the field names").build();
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Map fields = this.fieldsParam.required(args, context);
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Optional<String> prefix = this.prefixParam.optional(args, context);
        Optional<String> suffix = this.suffixParam.optional(args, context);
        if (fields != null) {
            fields.forEach((field, value) -> {
                if (prefix.isPresent()) {
                    field = (String)prefix.get() + field;
                }
                if (suffix.isPresent()) {
                    field = field + (String)suffix.get();
                }
                message.addField((String)field, value);
            });
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.fieldsParam, this.prefixParam, this.suffixParam, this.messageParam)).description("Sets new fields in a message").build();
    }
}

