/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.widgets.DashboardWidget;
import org.graylog2.dashboards.widgets.WidgetPosition;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.DateValidator;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.validators.Validator;
import org.joda.time.DateTime;

@CollectionName(value="dashboards")
public class DashboardImpl
extends PersistedImpl
implements Dashboard {
    public static final String FIELD_TITLE = "title";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_CONTENT_PACK = "content_pack";
    public static final String FIELD_CREATOR_USER_ID = "creator_user_id";
    public static final String FIELD_CREATED_AT = "created_at";
    public static final String EMBEDDED_WIDGETS = "widgets";
    public static final String EMBEDDED_POSITIONS = "positions";
    private Map<String, DashboardWidget> widgets = Maps.newHashMap();

    public DashboardImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected DashboardImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public String getTitle() {
        return (String)this.fields.get(FIELD_TITLE);
    }

    @Override
    public void setTitle(String title) {
        this.fields.put(FIELD_TITLE, title);
    }

    @Override
    public String getDescription() {
        return (String)this.fields.get(FIELD_DESCRIPTION);
    }

    @Override
    public void setDescription(String description) {
        this.fields.put(FIELD_DESCRIPTION, description);
    }

    @Override
    public List<WidgetPosition> getPositions() {
        BasicDBObject positions = (BasicDBObject)this.fields.get(EMBEDDED_POSITIONS);
        if (positions == null) {
            return Collections.emptyList();
        }
        ArrayList<WidgetPosition> result = new ArrayList<WidgetPosition>(positions.size());
        for (String positionId : positions.keySet()) {
            BasicDBObject position = (BasicDBObject)positions.get(positionId);
            int width = Integer.parseInt(position.get("width").toString());
            int height = Integer.parseInt(position.get("height").toString());
            int col = Integer.parseInt(position.get("col").toString());
            int row = Integer.parseInt(position.get("row").toString());
            WidgetPosition widgetPosition = WidgetPosition.builder().id(positionId).width(width).height(height).col(col).row(row).build();
            result.add(widgetPosition);
        }
        return result;
    }

    @Override
    public void setPositions(List<WidgetPosition> widgetPositions) {
        Preconditions.checkNotNull(widgetPositions, (Object)"widgetPositions must be given");
        HashMap positions = new HashMap(widgetPositions.size());
        for (WidgetPosition widgetPosition : widgetPositions) {
            HashMap<String, Integer> position = new HashMap<String, Integer>(4);
            position.put("width", widgetPosition.width());
            position.put("height", widgetPosition.height());
            position.put("col", widgetPosition.col());
            position.put("row", widgetPosition.row());
            positions.put(widgetPosition.id(), position);
        }
        Map<String, Object> fields = this.getFields();
        Preconditions.checkNotNull(fields, (Object)"No fields found!");
        fields.put(EMBEDDED_POSITIONS, positions);
    }

    @Override
    public String getContentPack() {
        return (String)this.fields.get(FIELD_CONTENT_PACK);
    }

    @Override
    public void setContentPack(String contentPack) {
        this.fields.put(FIELD_CONTENT_PACK, contentPack);
    }

    @Override
    public void addPersistedWidget(DashboardWidget widget) {
        this.widgets.put(widget.getId(), widget);
    }

    @Override
    public DashboardWidget getWidget(String widgetId) {
        return this.widgets.get(widgetId);
    }

    @Override
    public DashboardWidget addWidget(DashboardWidget widget) {
        return this.widgets.put(widget.getId(), widget);
    }

    @Override
    public DashboardWidget removeWidget(DashboardWidget widget) {
        return this.widgets.remove(widget.getId());
    }

    @Override
    public Map<String, DashboardWidget> getWidgets() {
        return ImmutableMap.copyOf(this.widgets);
    }

    @Override
    public Map<String, Validator> getValidations() {
        return ImmutableMap.builder().put((Object)FIELD_TITLE, (Object)new FilledStringValidator()).put((Object)FIELD_DESCRIPTION, (Object)new FilledStringValidator()).put((Object)FIELD_CONTENT_PACK, (Object)new OptionalStringValidator()).put((Object)FIELD_CREATOR_USER_ID, (Object)new FilledStringValidator()).put((Object)FIELD_CREATED_AT, (Object)new DateValidator()).build();
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap result = Maps.newHashMap((Map)this.fields);
        result.remove("_id");
        result.put("id", ((ObjectId)this.fields.get("_id")).toHexString());
        result.remove(FIELD_CREATED_AT);
        result.put(FIELD_CREATED_AT, Tools.getISO8601String((DateTime)this.fields.get(FIELD_CREATED_AT)));
        if (!result.containsKey(EMBEDDED_WIDGETS)) {
            result.put(EMBEDDED_WIDGETS, Collections.emptyList());
        }
        if (!result.containsKey(EMBEDDED_POSITIONS)) {
            result.put(EMBEDDED_POSITIONS, Collections.emptyMap());
        }
        return result;
    }
}

