/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class IndexFieldTypesService {
    private static final String FIELDS_FIELD_NAMES = String.format(Locale.US, "%s.%s", "fields", "field_name");
    private final JacksonDBCollection<IndexFieldTypesDTO, ObjectId> db;

    @Inject
    public IndexFieldTypesService(MongoConnection mongoConnection, MongoJackObjectMapperProvider objectMapperProvider) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection("index_field_types"), IndexFieldTypesDTO.class, ObjectId.class, (ObjectMapper)objectMapperProvider.get());
        this.db.createIndex((DBObject)new BasicDBObject((Map)ImmutableMap.of((Object)"index_name", (Object)1, (Object)"index_set_id", (Object)1)), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject("index_name", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject(FIELDS_FIELD_NAMES, (Object)1));
    }

    public Optional<IndexFieldTypesDTO> get(String idOrIndexName) {
        try {
            return Optional.ofNullable((IndexFieldTypesDTO)this.db.findOneById((Object)new ObjectId(idOrIndexName)));
        }
        catch (IllegalArgumentException e) {
            return Optional.ofNullable((IndexFieldTypesDTO)this.db.findOne(DBQuery.is((String)"index_name", (Object)idOrIndexName)));
        }
    }

    public IndexFieldTypesDTO save(IndexFieldTypesDTO dto) {
        WriteResult save = this.db.save((Object)dto);
        return (IndexFieldTypesDTO)save.getSavedObject();
    }

    public Optional<IndexFieldTypesDTO> upsert(IndexFieldTypesDTO dto) {
        WriteResult update = this.db.update(DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"index_name", (Object)dto.indexName()), DBQuery.is((String)"index_set_id", (Object)dto.indexSetId())}), (Object)dto, true, false);
        Object upsertedId = update.getUpsertedId();
        if (upsertedId instanceof ObjectId) {
            return this.get(((ObjectId)upsertedId).toHexString());
        }
        if (upsertedId instanceof String) {
            return this.get((String)upsertedId);
        }
        return Optional.empty();
    }

    public void delete(String idOrIndexName) {
        try {
            this.db.removeById((Object)new ObjectId(idOrIndexName));
        }
        catch (IllegalArgumentException e) {
            this.db.remove(DBQuery.is((String)"index_name", (Object)idOrIndexName));
        }
    }

    public Stream<IndexFieldTypesDTO> streamForIndexSet(String indexSetId) {
        return this.streamQuery(DBQuery.is((String)"index_set_id", (Object)indexSetId));
    }

    public Stream<IndexFieldTypesDTO> streamForFieldNames(Collection<String> fieldNames) {
        return this.streamQuery(DBQuery.in((String)FIELDS_FIELD_NAMES, fieldNames));
    }

    public Stream<IndexFieldTypesDTO> streamForFieldNamesAndIndices(Collection<String> fieldNames, Collection<String> indexNames) {
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"index_name", indexNames), DBQuery.in((String)FIELDS_FIELD_NAMES, fieldNames)});
        return this.streamQuery(query);
    }

    public Stream<IndexFieldTypesDTO> streamAll() {
        return this.streamQuery(DBQuery.empty());
    }

    private Stream<IndexFieldTypesDTO> streamQuery(DBQuery.Query query) {
        return Streams.stream((Iterable)this.db.find(query));
    }
}

