/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog2.indexer.fieldtypes.FieldTypeLookup;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;

public class MongoFieldTypeLookup
implements FieldTypeLookup {
    private final IndexFieldTypesService dbService;
    private final FieldTypeMapper typeMapper;

    @Inject
    public MongoFieldTypeLookup(IndexFieldTypesService dbService, FieldTypeMapper typeMapper) {
        this.dbService = dbService;
        this.typeMapper = typeMapper;
    }

    @Override
    public Optional<FieldTypes> get(String fieldName) {
        return Optional.ofNullable(this.get((Collection<String>)ImmutableSet.of((Object)fieldName)).get(fieldName));
    }

    @Override
    public Map<String, FieldTypes> get(Collection<String> fieldNames) {
        return this.get(fieldNames, (Collection<String>)ImmutableSet.of());
    }

    @Override
    public Map<String, FieldTypes> get(Collection<String> fieldNames, Collection<String> indexNames) {
        if (fieldNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap fields = new HashMap();
        this.getTypesStream(fieldNames, indexNames).forEach(types -> {
            String indexName = types.indexName();
            types.fields().forEach(fieldType -> {
                String fieldName = fieldType.fieldName();
                String physicalType = fieldType.physicalType();
                if (fieldNames.contains(fieldName) && (indexNames.isEmpty() || indexNames.contains(indexName))) {
                    if (!fields.containsKey(fieldName)) {
                        fields.put(fieldName, HashMultimap.create());
                    }
                    ((SetMultimap)fields.get(fieldName)).put((Object)physicalType, (Object)indexName);
                }
            });
        });
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry fieldNameEntry : fields.entrySet()) {
            String fieldName = (String)fieldNameEntry.getKey();
            Map physicalTypes = ((SetMultimap)fieldNameEntry.getValue()).asMap();
            Set<FieldTypes.Type> types2 = physicalTypes.entrySet().stream().map(entry -> {
                String physicalType = (String)entry.getKey();
                ImmutableSet indices = ImmutableSet.copyOf((Collection)((Collection)entry.getValue()));
                return this.typeMapper.mapType(physicalType).map(arg_0 -> MongoFieldTypeLookup.lambda$get$2((Set)indices, arg_0));
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
            result.put((Object)fieldName, (Object)FieldTypes.create(fieldName, types2));
        }
        return result.build();
    }

    private Stream<IndexFieldTypesDTO> getTypesStream(Collection<String> fieldNames, Collection<String> indexNames) {
        if (indexNames.isEmpty()) {
            return this.dbService.streamForFieldNames(fieldNames);
        }
        return this.dbService.streamForFieldNamesAndIndices(fieldNames, indexNames);
    }

    private static /* synthetic */ FieldTypes.Type lambda$get$2(Set indices, FieldTypes.Type t) {
        return t.withIndexNames(indices);
    }
}

