/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog2.indexer.indices.stats.AutoValue_IndexStatistics;
import org.graylog2.rest.models.system.indexer.responses.IndexStats;
import org.graylog2.rest.models.system.indexer.responses.ShardRouting;

@AutoValue
public abstract class IndexStatistics {
    public abstract String index();

    public abstract IndexStats primaryShards();

    public abstract IndexStats allShards();

    public abstract List<ShardRouting> routing();

    public static IndexStatistics create(String index, IndexStats primaryShards, IndexStats allShards, List<ShardRouting> routing) {
        return new AutoValue_IndexStatistics(index, primaryShards, allShards, routing);
    }

    public static IndexStatistics create(String index, JsonNode indexStats) {
        JsonNode primaries = indexStats.path("primaries");
        JsonNode total = indexStats.path("total");
        JsonNode shards = indexStats.path("shards");
        return IndexStatistics.create(index, IndexStatistics.buildIndexStats(primaries), IndexStatistics.buildIndexStats(total), IndexStatistics.buildShardRoutings(shards));
    }

    private static IndexStats buildIndexStats(JsonNode stats) {
        JsonNode flush = stats.path("flush");
        long flushTotal = flush.path("total").asLong();
        long flushTotalTimeSeconds = flush.path("total_time_in_millis").asLong() / 1000L;
        JsonNode get = stats.path("get");
        long getTotal = get.path("total").asLong();
        long getTotalTimeSeconds = get.path("total_time_in_millis").asLong() / 1000L;
        JsonNode indexing = stats.path("indexing");
        long indexingTotal = indexing.path("total").asLong();
        long indexingTotalTimeSeconds = indexing.path("total_time_in_millis").asLong() / 1000L;
        JsonNode merge = stats.path("merge");
        long mergeTotal = merge.path("total").asLong();
        long mergeTotalTimeSeconds = merge.path("total_time_in_millis").asLong() / 1000L;
        JsonNode refresh = stats.path("refresh");
        long refreshTotal = refresh.path("total").asLong();
        long refreshTotalTimeSeconds = refresh.path("total_time_in_millis").asLong() / 1000L;
        JsonNode search = stats.path("search");
        long searchQueryTotal = search.path("query_total").asLong();
        long searchQueryTotalTimeSeconds = search.path("query_time_in_millis").asLong() / 1000L;
        long searchFetchTotal = search.path("fetch_total").asLong();
        long searchFetchTotalTimeSeconds = search.path("fetch_time_in_millis").asLong() / 1000L;
        long searchOpenContexts = search.path("open_contexts").asLong();
        long storeSizeInBytes = stats.path("store").path("size_in_bytes").asLong();
        long segmentsCount = stats.path("segments").path("count").asLong();
        JsonNode docs = stats.path("docs");
        long docsCount = docs.path("count").asLong();
        long docsDeleted = docs.path("deleted").asLong();
        return IndexStats.create(IndexStats.TimeAndTotalStats.create(flushTotal, flushTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(getTotal, getTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(indexingTotal, indexingTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(mergeTotal, mergeTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(refreshTotal, refreshTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(searchQueryTotal, searchQueryTotalTimeSeconds), IndexStats.TimeAndTotalStats.create(searchFetchTotal, searchFetchTotalTimeSeconds), searchOpenContexts, storeSizeInBytes, segmentsCount, IndexStats.DocsStats.create(docsCount, docsDeleted));
    }

    private static List<ShardRouting> buildShardRoutings(JsonNode shardRoutings) {
        ImmutableList.Builder shardRoutingsBuilder = ImmutableList.builder();
        Iterator it = shardRoutings.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            int shardId = Integer.parseInt((String)entry.getKey());
            JsonNode shards = (JsonNode)entry.getValue();
            for (JsonNode jsonElement : shards) {
                JsonNode routing = jsonElement.path("routing");
                String state = routing.path("state").asText("unknown").toLowerCase(Locale.ENGLISH);
                boolean active = "started".equals(state) || "relocating".equals(state);
                boolean primary = routing.path("primary").asBoolean(false);
                String nodeId = routing.path("node").asText("Unknown");
                String nodeName = null;
                String nodeHostname = null;
                String relocatingNode = routing.path("relocating_node").asText(null);
                ShardRouting shardRouting = ShardRouting.create(shardId, state, active, primary, nodeId, nodeName, nodeHostname, relocatingNode);
                shardRoutingsBuilder.add((Object)shardRouting);
            }
        }
        return shardRoutingsBuilder.build();
    }
}

