/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.LegacyMongoIndexRangeService;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRangesMigrationPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangesMigrationPeriodical.class);
    private final Cluster cluster;
    private final IndexSetRegistry indexSetRegistry;
    private final IndexRangeService indexRangeService;
    private final NotificationService notificationService;
    private final LegacyMongoIndexRangeService legacyMongoIndexRangeService;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public IndexRangesMigrationPeriodical(Cluster cluster, IndexSetRegistry indexSetRegistry, IndexRangeService indexRangeService, NotificationService notificationService, LegacyMongoIndexRangeService legacyMongoIndexRangeService, ClusterConfigService clusterConfigService) {
        this.cluster = (Cluster)Preconditions.checkNotNull((Object)cluster);
        this.indexSetRegistry = (IndexSetRegistry)Preconditions.checkNotNull((Object)indexSetRegistry);
        this.indexRangeService = (IndexRangeService)Preconditions.checkNotNull((Object)indexRangeService);
        this.notificationService = (NotificationService)Preconditions.checkNotNull((Object)notificationService);
        this.legacyMongoIndexRangeService = (LegacyMongoIndexRangeService)Preconditions.checkNotNull((Object)legacyMongoIndexRangeService);
        this.clusterConfigService = (ClusterConfigService)Preconditions.checkNotNull((Object)clusterConfigService);
    }

    @Override
    public void doRun() {
        SortedSet<IndexRange> allIndexRanges;
        int numberOfIndexRanges;
        MongoIndexRangesMigrationComplete migrationComplete = this.clusterConfigService.get(MongoIndexRangesMigrationComplete.class);
        if (migrationComplete != null && migrationComplete.complete) {
            LOG.debug("Migration of index ranges (pre Graylog 1.2.2) already complete. Skipping migration process.");
            return;
        }
        while (!this.cluster.isConnected() || !this.cluster.isHealthy()) {
            Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        ImmutableSet indexNames = ImmutableSet.copyOf((Object[])this.indexSetRegistry.getManagedIndices());
        SortedSet<IndexRange> mongoIndexRanges = this.legacyMongoIndexRangeService.findAll();
        for (IndexRange indexRange2 : mongoIndexRanges) {
            if (indexNames.contains(indexRange2.indexName())) {
                LOG.info("Migrating index range from MongoDB: {}", (Object)indexRange2);
                this.indexRangeService.save(indexRange2);
            } else {
                LOG.info("Removing stale index range from MongoDB: {}", (Object)indexRange2);
            }
            this.legacyMongoIndexRangeService.delete(indexRange2.indexName());
        }
        int numberOfIndices = indexNames.size();
        if (numberOfIndices > (numberOfIndexRanges = (allIndexRanges = this.indexRangeService.findAll()).size())) {
            LOG.info("There are more indices ({}) than there are index ranges ({}). Notifying administrator.", (Object)numberOfIndices, (Object)numberOfIndexRanges);
            HashSet extraIndices = Sets.newHashSet((Iterable)indexNames);
            allIndexRanges.forEach(indexRange -> extraIndices.remove(indexRange.indexName()));
            Set affectedIndexSetNames = extraIndices.stream().map(this.indexSetRegistry::getForIndex).filter(Optional::isPresent).map(Optional::get).map(IndexSet::getConfig).map(IndexSetConfig::title).collect(Collectors.toSet());
            Notification notification = this.notificationService.buildNow().addSeverity(Notification.Severity.URGENT).addType(Notification.Type.INDEX_RANGES_RECALCULATION).addDetail("indices", numberOfIndices).addDetail("index_ranges", numberOfIndexRanges).addDetail("index_sets", affectedIndexSetNames.isEmpty() ? null : Joiner.on((String)", ").join(affectedIndexSetNames));
            this.notificationService.publishIfFirst(notification);
        }
        this.clusterConfigService.write(new MongoIndexRangesMigrationComplete(true));
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @JsonAutoDetect
    public static class MongoIndexRangesMigrationComplete {
        @JsonProperty
        public boolean complete;

        @JsonCreator
        public MongoIndexRangesMigrationComplete(@JsonProperty(value="complete") boolean complete) {
            this.complete = complete;
        }
    }
}

