/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AutoValue_AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.InvalidRangeParametersException;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@JsonTypeName(value="absolute")
@AutoValue
public abstract class AbsoluteRange
extends TimeRange {
    public static final String ABSOLUTE = "absolute";

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty
    public abstract DateTime from();

    @JsonProperty
    public abstract DateTime to();

    public static Builder builder() {
        return new AutoValue_AbsoluteRange.Builder();
    }

    @JsonCreator
    public static AbsoluteRange create(@JsonProperty(value="type") String type, @JsonProperty(value="from") DateTime from, @JsonProperty(value="to") DateTime to) {
        return AbsoluteRange.builder().type(type).from(from).to(to).build();
    }

    public static AbsoluteRange create(DateTime from, DateTime to) {
        return AbsoluteRange.builder().type(ABSOLUTE).from(from).to(to).build();
    }

    public static AbsoluteRange create(String from, String to) throws InvalidRangeParametersException {
        return AbsoluteRange.builder().type(ABSOLUTE).from(from).to(to).build();
    }

    @Override
    public DateTime getFrom() {
        return this.from();
    }

    @Override
    public DateTime getTo() {
        return this.to();
    }

    @Override
    public Map<String, Object> getPersistedConfig() {
        return ImmutableMap.of((Object)"type", (Object)ABSOLUTE, (Object)"from", (Object)this.getFrom(), (Object)"to", (Object)this.getTo());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract AbsoluteRange build();

        public abstract Builder type(String var1);

        public abstract Builder to(DateTime var1);

        public abstract Builder from(DateTime var1);

        public Builder to(String to) throws InvalidRangeParametersException {
            try {
                return this.to(this.parseDateTime(to));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRangeParametersException("Invalid end of range: " + to, e);
            }
        }

        public Builder from(String from) throws InvalidRangeParametersException {
            try {
                return this.from(this.parseDateTime(from));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRangeParametersException("Invalid start of range: " + from, e);
            }
        }

        private DateTime parseDateTime(String to) {
            DateTimeFormatter formatter = to.contains("T") ? ISODateTimeFormat.dateTime() : Tools.timeFormatterWithOptionalMilliseconds();
            return formatter.withOffsetParsed().parseDateTime(to);
        }
    }
}

