/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.transports;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.netty.ChannelRegistrationHandler;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.inputs.transports.netty.ServerSocketChannelFactory;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.transports.NettyTransport;
import org.graylog2.plugin.inputs.transports.util.KeyUtil;
import org.graylog2.plugin.inputs.util.ConnectionCounter;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTcpTransport
extends NettyTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTcpTransport.class);
    private static final String CK_TLS_CERT_FILE = "tls_cert_file";
    private static final String CK_TLS_KEY_FILE = "tls_key_file";
    private static final String CK_TLS_ENABLE = "tls_enable";
    private static final String CK_TLS_KEY_PASSWORD = "tls_key_password";
    private static final String CK_TLS_CLIENT_AUTH = "tls_client_auth";
    private static final String CK_TLS_CLIENT_AUTH_TRUSTED_CERT_FILE = "tls_client_auth_cert_file";
    private static final String CK_TCP_KEEPALIVE = "tcp_keepalive";
    private static final String TLS_CLIENT_AUTH_DISABLED = "disabled";
    private static final String TLS_CLIENT_AUTH_OPTIONAL = "optional";
    private static final String TLS_CLIENT_AUTH_REQUIRED = "required";
    private static final Map<String, String> TLS_CLIENT_AUTH_OPTIONS = ImmutableMap.of((Object)"disabled", (Object)"disabled", (Object)"optional", (Object)"optional", (Object)"required", (Object)"required");
    private final ConnectionCounter connectionCounter;
    private final AtomicInteger connections;
    private final AtomicLong totalConnections;
    protected final Configuration configuration;
    protected final EventLoopGroup parentEventLoopGroup;
    private final NettyTransportConfiguration nettyTransportConfiguration;
    private final AtomicReference<Channel> channelReference;
    private final boolean tlsEnable;
    private final String tlsKeyPassword;
    private File tlsCertFile;
    private File tlsKeyFile;
    private final File tlsClientAuthCertFile;
    private final String tlsClientAuth;
    private final boolean tcpKeepalive;
    private ChannelGroup childChannels;
    protected EventLoopGroup childEventLoopGroup;
    private ServerBootstrap bootstrap;

    public AbstractTcpTransport(Configuration configuration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry, EventLoopGroup parentEventLoopGroup, EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration nettyTransportConfiguration) {
        super(configuration, eventLoopGroupFactory, throughputCounter, localRegistry);
        this.configuration = configuration;
        this.parentEventLoopGroup = parentEventLoopGroup;
        this.nettyTransportConfiguration = nettyTransportConfiguration;
        this.channelReference = new AtomicReference();
        this.childChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.tlsEnable = configuration.getBoolean(CK_TLS_ENABLE);
        this.tlsCertFile = this.getTlsFile(configuration, CK_TLS_CERT_FILE);
        this.tlsKeyFile = this.getTlsFile(configuration, CK_TLS_KEY_FILE);
        this.tlsKeyPassword = configuration.getString(CK_TLS_KEY_PASSWORD);
        this.tlsClientAuth = configuration.getString(CK_TLS_CLIENT_AUTH, TLS_CLIENT_AUTH_DISABLED);
        this.tlsClientAuthCertFile = this.getTlsFile(configuration, CK_TLS_CLIENT_AUTH_TRUSTED_CERT_FILE);
        this.tcpKeepalive = configuration.getBoolean(CK_TCP_KEEPALIVE);
        this.connections = new AtomicInteger();
        this.totalConnections = new AtomicLong();
        this.connectionCounter = new ConnectionCounter(this.connections, this.totalConnections);
        this.localRegistry.register("open_connections", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return AbstractTcpTransport.this.connections.get();
            }
        });
        this.localRegistry.register("total_connections", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return AbstractTcpTransport.this.totalConnections.get();
            }
        });
    }

    private File getTlsFile(Configuration configuration, String configKey) {
        return new File(configuration.getString(configKey, ""));
    }

    protected ServerBootstrap getBootstrap(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> parentHandlers = this.getChannelHandlers(input);
        LinkedHashMap<String, Callable<? extends ChannelHandler>> childHandlers = this.getChildChannelHandlers(input);
        this.childEventLoopGroup = this.eventLoopGroupFactory.create(this.workerThreads, this.localRegistry, "workers");
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.parentEventLoopGroup, this.childEventLoopGroup).channelFactory((ChannelFactory)new ServerSocketChannelFactory(this.nettyTransportConfiguration.getType()))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(8192))).option(ChannelOption.SO_RCVBUF, (Object)this.getRecvBufferSize())).childOption(ChannelOption.SO_RCVBUF, (Object)this.getRecvBufferSize()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepalive).handler(this.getChannelInitializer(parentHandlers))).childHandler(this.getChannelInitializer(childHandlers));
    }

    @Override
    public void launch(MessageInput input) throws MisfireException {
        try {
            this.bootstrap = this.getBootstrap(input);
            this.bootstrap.bind((SocketAddress)this.socketAddress).addListener((GenericFutureListener)new InputLaunchListener(this.channelReference, input, this.getRecvBufferSize())).syncUninterruptibly();
        }
        catch (Exception e) {
            throw new MisfireException(e);
        }
    }

    @Override
    @Nullable
    public SocketAddress getLocalAddress() {
        Channel channel = this.channelReference.get();
        if (channel != null) {
            return channel.localAddress();
        }
        return null;
    }

    @Override
    public void stop() {
        Channel channel = this.channelReference.get();
        if (channel != null) {
            channel.close();
            channel.closeFuture().syncUninterruptibly();
        }
        this.childChannels.close().syncUninterruptibly();
        if (this.childEventLoopGroup != null) {
            this.childEventLoopGroup.shutdownGracefully();
        }
        this.bootstrap = null;
    }

    @Override
    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChildChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlers = new LinkedHashMap<String, Callable<? extends ChannelHandler>>();
        handlers.put("channel-registration", () -> new ChannelRegistrationHandler(this.childChannels));
        handlers.put("traffic-counter", () -> this.throughputCounter);
        handlers.put("connection-counter", () -> this.connectionCounter);
        if (this.tlsEnable) {
            LOG.info("Enabled TLS for input [{}/{}]. key-file=\"{}\" cert-file=\"{}\"", new Object[]{input.getName(), input.getId(), this.tlsKeyFile, this.tlsCertFile});
            handlers.put("tls", this.getSslHandlerCallable(input));
        }
        handlers.putAll(super.getChildChannelHandlers(input));
        return handlers;
    }

    private Callable<ChannelHandler> getSslHandlerCallable(MessageInput input) {
        ClientAuth clientAuth;
        File keyFile;
        File certFile;
        if (this.tlsCertFile.exists() && this.tlsKeyFile.exists()) {
            certFile = this.tlsCertFile;
            keyFile = this.tlsKeyFile;
        } else {
            LOG.warn("TLS key file or certificate file does not exist, creating a self-signed certificate for input [{}/{}].", (Object)input.getName(), (Object)input.getId());
            String tmpDir = System.getProperty("java.io.tmpdir");
            Preconditions.checkState((tmpDir != null ? 1 : 0) != 0, (Object)"The temporary directory must not be null!");
            Path tmpPath = Paths.get(tmpDir, new String[0]);
            if (!Files.isDirectory(tmpPath, new LinkOption[0]) || !Files.isWritable(tmpPath)) {
                throw new IllegalStateException("Couldn't write to temporary directory: " + tmpPath.toAbsolutePath());
            }
            try {
                SelfSignedCertificate ssc = new SelfSignedCertificate(this.configuration.getString("bind_address") + ":" + this.configuration.getString("port"));
                certFile = ssc.certificate();
                keyFile = ssc.privateKey();
            }
            catch (CertificateException e) {
                String msg = String.format(Locale.ENGLISH, "Problem creating a self-signed certificate for input [%s/%s].", input.getName(), input.getId());
                throw new IllegalStateException(msg, e);
            }
        }
        switch (this.tlsClientAuth) {
            case "disabled": {
                LOG.debug("Not using TLS client authentication");
                clientAuth = ClientAuth.NONE;
                break;
            }
            case "optional": {
                LOG.debug("Using optional TLS client authentication");
                clientAuth = ClientAuth.OPTIONAL;
                break;
            }
            case "required": {
                LOG.debug("Using mandatory TLS client authentication");
                clientAuth = ClientAuth.REQUIRE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown TLS client authentication mode: " + this.tlsClientAuth);
            }
        }
        return this.buildSslHandlerCallable(this.nettyTransportConfiguration.getTlsProvider(), certFile, keyFile, this.tlsKeyPassword, clientAuth, this.tlsClientAuthCertFile);
    }

    private Callable<ChannelHandler> buildSslHandlerCallable(final SslProvider tlsProvider, final File certFile, final File keyFile, final String password, final ClientAuth clientAuth, final File clientAuthCertFile) {
        return new Callable<ChannelHandler>(){

            @Override
            public ChannelHandler call() throws Exception {
                try {
                    return new SslHandler(this.createSslEngine());
                }
                catch (SSLException e) {
                    LOG.error("Error creating SSL context. Make sure the certificate and key are in the correct format: cert=X.509 key=PKCS#8");
                    throw e;
                }
            }

            private SSLEngine createSslEngine() throws IOException, CertificateException {
                X509Certificate[] clientAuthCerts;
                if (EnumSet.of(ClientAuth.OPTIONAL, ClientAuth.REQUIRE).contains(clientAuth)) {
                    if (clientAuthCertFile.exists()) {
                        clientAuthCerts = (X509Certificate[])KeyUtil.loadCertificates(clientAuthCertFile.toPath()).stream().filter(certificate -> certificate instanceof X509Certificate).map(certificate -> (X509Certificate)certificate).toArray(X509Certificate[]::new);
                    } else {
                        LOG.warn("Client auth configured, but no authorized certificates / certificate authorities configured");
                        clientAuthCerts = null;
                    }
                } else {
                    clientAuthCerts = null;
                }
                SslContext sslContext = SslContextBuilder.forServer((File)certFile, (File)keyFile, (String)Strings.emptyToNull((String)password)).sslProvider(tlsProvider).clientAuth(clientAuth).trustManager(clientAuthCerts).build();
                return sslContext.newEngine(ByteBufAllocator.DEFAULT);
            }
        };
    }

    private static class InputLaunchListener
    implements ChannelFutureListener {
        private final AtomicReference<Channel> channelReference;
        private final MessageInput input;
        private final int expectedRecvBufferSize;

        public InputLaunchListener(AtomicReference<Channel> channelReference, MessageInput input, int expectedRecvBufferSize) {
            this.channelReference = channelReference;
            this.input = input;
            this.expectedRecvBufferSize = expectedRecvBufferSize;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                this.channelReference.set(channel);
                LOG.debug("Started channel {}", (Object)channel);
                ServerSocketChannelConfig channelConfig = (ServerSocketChannelConfig)channel.config();
                int receiveBufferSize = channelConfig.getReceiveBufferSize();
                if (receiveBufferSize != this.expectedRecvBufferSize) {
                    LOG.warn("receiveBufferSize (SO_RCVBUF) for input {} (channel {}) should be {} but is {}.", new Object[]{this.input, channel, this.expectedRecvBufferSize, receiveBufferSize});
                }
            } else {
                LOG.warn("Failed to start channel for input {}", (Object)this.input, (Object)future.cause());
            }
        }
    }

    @ConfigClass
    public static class Config
    extends NettyTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest x = super.getRequestedConfiguration();
            x.addField(new TextField(AbstractTcpTransport.CK_TLS_CERT_FILE, "TLS cert file", "", "Path to the TLS certificate file", ConfigurationField.Optional.OPTIONAL));
            x.addField(new TextField(AbstractTcpTransport.CK_TLS_KEY_FILE, "TLS private key file", "", "Path to the TLS private key file", ConfigurationField.Optional.OPTIONAL));
            x.addField(new BooleanField(AbstractTcpTransport.CK_TLS_ENABLE, "Enable TLS", false, "Accept TLS connections"));
            x.addField(new TextField(AbstractTcpTransport.CK_TLS_KEY_PASSWORD, "TLS key password", "", "The password for the encrypted key file.", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.IS_PASSWORD));
            x.addField(new DropdownField(AbstractTcpTransport.CK_TLS_CLIENT_AUTH, "TLS client authentication", AbstractTcpTransport.TLS_CLIENT_AUTH_DISABLED, TLS_CLIENT_AUTH_OPTIONS, "Whether clients need to authenticate themselves in a TLS connection", ConfigurationField.Optional.OPTIONAL));
            x.addField(new TextField(AbstractTcpTransport.CK_TLS_CLIENT_AUTH_TRUSTED_CERT_FILE, "TLS Client Auth Trusted Certs", "", "TLS Client Auth Trusted Certs  (File or Directory)", ConfigurationField.Optional.OPTIONAL));
            x.addField(new BooleanField(AbstractTcpTransport.CK_TCP_KEEPALIVE, "TCP keepalive", false, "Enable TCP keepalive packets"));
            return x;
        }
    }
}

