/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.transports;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;
import org.graylog2.inputs.transports.netty.ExceptionLoggingChannelHandler;
import org.graylog2.inputs.transports.netty.MessageAggregationHandler;
import org.graylog2.inputs.transports.netty.PromiseFailureHandler;
import org.graylog2.inputs.transports.netty.RawMessageHandler;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.MetricSets;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.NumberField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.PacketInformationDumper;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyTransport
implements Transport {
    public static final String CK_BIND_ADDRESS = "bind_address";
    public static final String CK_PORT = "port";
    public static final String CK_RECV_BUFFER_SIZE = "recv_buffer_size";
    public static final String CK_NUMBER_WORKER_THREADS = "number_worker_threads";
    private static final int DEFAULT_NUMBER_WORKER_THREADS = Runtime.getRuntime().availableProcessors();
    private static final Logger log = LoggerFactory.getLogger(NettyTransport.class);
    protected final EventLoopGroupFactory eventLoopGroupFactory;
    protected final MetricRegistry localRegistry;
    protected final InetSocketAddress socketAddress;
    protected final ThroughputCounter throughputCounter;
    protected final int workerThreads;
    private final int recvBufferSize;
    @Nullable
    private CodecAggregator aggregator;

    public NettyTransport(Configuration configuration, EventLoopGroupFactory eventLoopGroupFactory, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry) {
        this.throughputCounter = throughputCounter;
        String hostname = configuration.getString(CK_BIND_ADDRESS);
        this.socketAddress = hostname != null && configuration.intIsSet(CK_PORT) ? new InetSocketAddress(hostname, configuration.getInt(CK_PORT)) : null;
        this.recvBufferSize = configuration.intIsSet(CK_RECV_BUFFER_SIZE) ? configuration.getInt(CK_RECV_BUFFER_SIZE) : MessageInput.getDefaultRecvBufferSize();
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.workerThreads = configuration.getInt(CK_NUMBER_WORKER_THREADS, DEFAULT_NUMBER_WORKER_THREADS);
        this.localRegistry = localRegistry;
        localRegistry.registerAll(MetricSets.of(throughputCounter.gauges()));
    }

    protected ChannelInitializer<? extends Channel> getChannelInitializer(final LinkedHashMap<String, Callable<? extends ChannelHandler>> handlerList) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                for (Map.Entry entry : handlerList.entrySet()) {
                    p.addLast((String)entry.getKey(), (ChannelHandler)((Callable)entry.getValue()).call());
                }
            }
        };
    }

    @Nullable
    @VisibleForTesting
    public abstract SocketAddress getLocalAddress();

    @Override
    public void setMessageAggregator(@Nullable CodecAggregator aggregator) {
        this.aggregator = aggregator;
    }

    @Nullable
    protected CodecAggregator getAggregator() {
        return this.aggregator;
    }

    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlerList = new LinkedHashMap<String, Callable<? extends ChannelHandler>>();
        handlerList.put("exception-logger", () -> new ExceptionLoggingChannelHandler(input, log));
        handlerList.put("packet-meta-dumper", () -> new PacketInformationDumper(input));
        handlerList.put("output-failure-logger", () -> PromiseFailureHandler.INSTANCE);
        return handlerList;
    }

    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getCustomChildChannelHandlers(MessageInput input) {
        return new LinkedHashMap<String, Callable<? extends ChannelHandler>>();
    }

    protected LinkedHashMap<String, Callable<? extends ChannelHandler>> getChildChannelHandlers(MessageInput input) {
        LinkedHashMap<String, Callable<? extends ChannelHandler>> handlerList = new LinkedHashMap<String, Callable<? extends ChannelHandler>>(this.getCustomChildChannelHandlers(input));
        if (this.aggregator != null) {
            log.debug("Adding codec aggregator {} to channel pipeline", (Object)this.aggregator);
            handlerList.put("codec-aggregator", () -> new MessageAggregationHandler(this.aggregator, this.localRegistry));
        }
        handlerList.put("rawmessage-handler", () -> new RawMessageHandler(input));
        return handlerList;
    }

    protected int getRecvBufferSize() {
        return this.recvBufferSize;
    }

    @Override
    public MetricSet getMetricSet() {
        return this.localRegistry;
    }

    public static class Config
    implements Transport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = new ConfigurationRequest();
            r.addField(ConfigurationRequest.Templates.bindAddress(NettyTransport.CK_BIND_ADDRESS));
            r.addField(ConfigurationRequest.Templates.portNumber(NettyTransport.CK_PORT, 5555));
            r.addField(ConfigurationRequest.Templates.recvBufferSize(NettyTransport.CK_RECV_BUFFER_SIZE, 0x100000));
            r.addField(new NumberField(NettyTransport.CK_NUMBER_WORKER_THREADS, "No. of worker threads", DEFAULT_NUMBER_WORKER_THREADS, "Number of worker threads processing network connections for this input.", ConfigurationField.Optional.OPTIONAL, NumberField.Attribute.ONLY_POSITIVE));
            return r;
        }
    }
}

