/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.dashboards;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.dashboards.Dashboard;
import org.graylog2.dashboards.DashboardService;
import org.graylog2.dashboards.events.DashboardDeletedEvent;
import org.graylog2.dashboards.widgets.events.WidgetUpdatedEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.dashboards.requests.CreateDashboardRequest;
import org.graylog2.rest.models.dashboards.requests.UpdateDashboardRequest;
import org.graylog2.rest.models.dashboards.requests.WidgetPositionsRequest;
import org.graylog2.rest.models.dashboards.responses.DashboardList;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="Dashboards", description="Manage dashboards")
@Path(value="/dashboards")
public class DashboardsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardsResource.class);
    private final DashboardService dashboardService;
    private final ActivityWriter activityWriter;
    private final ClusterEventBus clusterEventBus;
    private final EventBus serverEventBus;

    @Inject
    public DashboardsResource(DashboardService dashboardService, ActivityWriter activityWriter, ClusterEventBus clusterEventBus, EventBus serverEventBus) {
        this.dashboardService = dashboardService;
        this.activityWriter = activityWriter;
        this.clusterEventBus = clusterEventBus;
        this.serverEventBus = serverEventBus;
    }

    @POST
    @Timed
    @ApiOperation(value="Create a dashboard")
    @RequiresPermissions(value={"dashboards:create"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AuditEvent(type="server:dashboard:create")
    public Response create(@ApiParam(name="JSON body", required=true) CreateDashboardRequest cr) throws ValidationException {
        Dashboard dashboard = this.dashboardService.create(cr.title(), cr.description(), this.getCurrentUser().getName(), Tools.nowUTC());
        String id = this.dashboardService.save(dashboard);
        ImmutableMap result = ImmutableMap.of((Object)"dashboard_id", (Object)id);
        URI dashboardUri = this.getUriBuilderToSelf().path(DashboardsResource.class, "get").build(new Object[]{id});
        User user = this.getCurrentUser();
        if (!user.isLocalAdmin()) {
            ImmutableList permissions = ImmutableList.builder().addAll(user.getPermissions()).add((Object)("dashboards:read:" + id)).add((Object)("dashboards:edit:" + id)).build();
            user.setPermissions((List<String>)permissions);
            this.userService.save(user);
        }
        return Response.created((URI)dashboardUri).entity((Object)result).build();
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all dashboards and all configurations of their widgets.")
    @Produces(value={"application/json"})
    public DashboardList list() {
        ArrayList dashboards = Lists.newArrayList();
        for (Dashboard dashboard : this.dashboardService.all()) {
            if (!this.isPermitted("dashboards:read", dashboard.getId())) continue;
            dashboards.add(dashboard.asMap());
        }
        return DashboardList.create(dashboards.size(), dashboards);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a single dashboards and all configurations of its widgets.")
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @Produces(value={"application/json"})
    public Map<String, Object> get(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws NotFoundException {
        this.checkPermission("dashboards:read", dashboardId);
        return this.dashboardService.load(dashboardId).asMap();
    }

    @DELETE
    @Timed
    @ApiOperation(value="Delete a dashboard and all its widgets")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @AuditEvent(type="server:dashboard:delete")
    public void delete(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId) throws NotFoundException, ValidationException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        dashboard.getWidgets().values().forEach(widget -> this.clusterEventBus.post(WidgetUpdatedEvent.create(widget)));
        this.dashboardService.destroy(dashboard);
        String msg = "Deleted dashboard <" + dashboard.getId() + ">. Reason: REST request.";
        LOG.info(msg);
        this.activityWriter.write(new Activity(msg, DashboardsResource.class));
        this.serverEventBus.post((Object)DashboardDeletedEvent.create(dashboard.getId()));
    }

    @PUT
    @Timed
    @ApiOperation(value="Update the settings of a dashboard.")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @AuditEvent(type="server:dashboard:update")
    public void update(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) UpdateDashboardRequest cr) throws ValidationException, NotFoundException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        if (cr.title() != null) {
            dashboard.setTitle(cr.title());
        }
        if (cr.description() != null) {
            dashboard.setDescription(cr.description());
        }
        this.dashboardService.save(dashboard);
    }

    @PUT
    @Timed
    @ApiOperation(value="Update/set the positions of dashboard widgets.")
    @Produces(value={"application/json"})
    @Path(value="/{dashboardId}/positions")
    @ApiResponses(value={@ApiResponse(code=404, message="Dashboard not found.")})
    @AuditEvent(type="server:dashboard_widget_positions:update")
    public void setPositions(@ApiParam(name="dashboardId", required=true) @PathParam(value="dashboardId") String dashboardId, @ApiParam(name="JSON body", required=true) @Valid WidgetPositionsRequest uwpr) throws NotFoundException, ValidationException {
        this.checkPermission("dashboards:edit", dashboardId);
        Dashboard dashboard = this.dashboardService.load(dashboardId);
        this.dashboardService.updateWidgetPositions(dashboard, uwpr);
    }
}

