/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.ldap;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.net.URI;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.shiro.codec.Hex;
import org.bson.types.ObjectId;
import org.graylog2.Configuration;
import org.graylog2.database.CollectionName;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedImpl;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.security.AESTools;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CollectionName(value="ldap_settings")
public class LdapSettingsImpl
extends PersistedImpl
implements LdapSettings {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSettingsImpl.class);
    public static final String ENABLED = "enabled";
    public static final String SYSTEM_USERNAME = "system_username";
    public static final String SYSTEM_PASSWORD = "system_password";
    public static final String SYSTEM_PASSWORD_SALT = "system_password_salt";
    public static final String LDAP_URI = "ldap_uri";
    public static final String SEARCH_PATTERN = "principal_search_pattern";
    public static final String SEARCH_BASE = "search_base";
    public static final String DISPLAY_NAME_ATTRIBUTE = "username_attribute";
    public static final String USE_START_TLS = "use_start_tls";
    public static final String ACTIVE_DIRECTORY = "active_directory";
    public static final String DEFAULT_GROUP = "default_group";
    public static final String TRUST_ALL_CERTS = "trust_all_certificates";
    public static final String GROUP_MAPPING = "group_role_mapping";
    public static final String GROUP_MAPPING_LIST = "group_role_mapping_list";
    public static final String GROUP_SEARCH_BASE = "group_search_base";
    public static final String GROUP_ID_ATTRIBUTE = "group_id_attribute";
    public static final String GROUP_SEARCH_PATTERN = "group_search_pattern";
    public static final String ADDITIONAL_DEFAULT_GROUPS = "additional_default_groups";
    public static final String LDAP_GROUP_MAPPING_NAMEKEY = "group";
    public static final String LDAP_GROUP_MAPPING_ROLEKEY = "role_id";
    protected Configuration configuration;
    private final RoleService roleService;

    @AssistedInject
    public LdapSettingsImpl(Configuration configuration, RoleService roleService) {
        super(Maps.newHashMap());
        this.configuration = configuration;
        this.roleService = roleService;
    }

    @AssistedInject
    public LdapSettingsImpl(Configuration configuration, RoleService roleService, @Assisted ObjectId id, @Assisted Map<String, Object> fields) {
        super(id, fields);
        this.configuration = configuration;
        this.roleService = roleService;
    }

    @Override
    public Map<String, Validator> getValidations() {
        return null;
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return null;
    }

    @Override
    public String getSystemUserName() {
        return Strings.nullToEmpty((String)((String)this.fields.get(SYSTEM_USERNAME)));
    }

    @Override
    public void setSystemUsername(String systemUsername) {
        this.fields.put(SYSTEM_USERNAME, systemUsername);
    }

    @Override
    public String getSystemPassword() {
        Object o = this.fields.get(SYSTEM_PASSWORD);
        if (o == null) {
            return "";
        }
        if (this.getSystemPasswordSalt().isEmpty()) {
            LOG.debug("Old database version does not have salted, encrypted password. Please save the LDAP settings again.");
            return o.toString();
        }
        String encryptedPw = o.toString();
        return AESTools.decrypt(encryptedPw, this.configuration.getPasswordSecret().substring(0, 16), this.getSystemPasswordSalt());
    }

    @Override
    public boolean isSystemPasswordSet() {
        Object o = this.fields.get(SYSTEM_PASSWORD);
        return o != null;
    }

    @Override
    public void setSystemPassword(String systemPassword) {
        if (systemPassword == null || systemPassword.isEmpty()) {
            return;
        }
        if (this.getSystemPasswordSalt().isEmpty()) {
            LOG.debug("Generating new salt for LDAP system password.");
            SecureRandom random = new SecureRandom();
            byte[] saltBytes = new byte[8];
            random.nextBytes(saltBytes);
            this.setSystemPasswordSalt(Hex.encodeToString((byte[])saltBytes));
        }
        String encrypted = AESTools.encrypt(systemPassword, this.configuration.getPasswordSecret().substring(0, 16), this.getSystemPasswordSalt());
        this.fields.put(SYSTEM_PASSWORD, encrypted);
    }

    @Override
    public String getSystemPasswordSalt() {
        return Strings.nullToEmpty((String)((String)this.fields.get(SYSTEM_PASSWORD_SALT)));
    }

    @Override
    public void setSystemPasswordSalt(String salt) {
        this.fields.put(SYSTEM_PASSWORD_SALT, salt);
    }

    @Override
    public URI getUri() {
        Object o = this.fields.get(LDAP_URI);
        return o != null ? URI.create(o.toString()) : null;
    }

    @Override
    public void setUri(URI ldapUri) {
        this.fields.put(LDAP_URI, ldapUri.toString());
    }

    @Override
    public String getSearchBase() {
        return Strings.nullToEmpty((String)((String)this.fields.get(SEARCH_BASE)));
    }

    @Override
    public void setSearchBase(String searchBase) {
        this.fields.put(SEARCH_BASE, searchBase);
    }

    @Override
    public String getSearchPattern() {
        return Strings.nullToEmpty((String)((String)this.fields.get(SEARCH_PATTERN)));
    }

    @Override
    public void setSearchPattern(String searchPattern) {
        this.fields.put(SEARCH_PATTERN, searchPattern);
    }

    @Override
    public String getDisplayNameAttribute() {
        return Strings.nullToEmpty((String)((String)this.fields.get(DISPLAY_NAME_ATTRIBUTE)));
    }

    @Override
    public void setDisplayNameAttribute(String displayNameAttribute) {
        this.fields.put(DISPLAY_NAME_ATTRIBUTE, displayNameAttribute);
    }

    @Override
    public boolean isEnabled() {
        Object o = this.fields.get(ENABLED);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fields.put(ENABLED, enabled);
    }

    @Override
    public void setUseStartTls(boolean useStartTls) {
        this.fields.put(USE_START_TLS, useStartTls);
    }

    @Override
    public boolean isUseStartTls() {
        Object o = this.fields.get(USE_START_TLS);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    @Override
    public void setActiveDirectory(boolean activeDirectory) {
        this.fields.put(ACTIVE_DIRECTORY, activeDirectory);
    }

    @Override
    public boolean isActiveDirectory() {
        Object o = this.fields.get(ACTIVE_DIRECTORY);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    @Override
    public String getDefaultGroup() {
        String defaultGroupId = this.getDefaultGroupId();
        if (defaultGroupId.equals(this.roleService.getReaderRoleObjectId())) {
            return "Reader";
        }
        try {
            Map<String, Role> idToRole = this.roleService.loadAllIdMap();
            return idToRole.get(defaultGroupId).getName();
        }
        catch (Exception e) {
            LOG.error("Unable to load role mapping");
            return "Reader";
        }
    }

    @Override
    public String getDefaultGroupId() {
        Object o = this.fields.get(DEFAULT_GROUP);
        return o == null ? this.roleService.getReaderRoleObjectId() : (String)o;
    }

    @Override
    public void setDefaultGroup(String defaultGroup) {
        String groupId = this.roleService.getReaderRoleObjectId();
        try {
            groupId = this.roleService.load(defaultGroup).getId();
        }
        catch (NotFoundException e) {
            LOG.error("Unable to load role mapping");
        }
        this.fields.put(DEFAULT_GROUP, groupId);
    }

    @Override
    public boolean isTrustAllCertificates() {
        Object o = this.fields.get(TRUST_ALL_CERTS);
        return o != null ? Boolean.valueOf(o.toString()) : false;
    }

    @Override
    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.fields.put(TRUST_ALL_CERTS, trustAllCertificates);
    }

    @Override
    @Nonnull
    public Map<String, String> getGroupMapping() {
        Map<String, String> groupMapping;
        BasicDBList groupMappingList = (BasicDBList)this.fields.get(GROUP_MAPPING_LIST);
        if (groupMappingList == null) {
            groupMapping = (Map)this.fields.get(GROUP_MAPPING);
        } else {
            groupMapping = Maps.newHashMapWithExpectedSize((int)groupMappingList.size());
            for (Object entry : groupMappingList) {
                DBObject field = (DBObject)entry;
                groupMapping.put((String)field.get(LDAP_GROUP_MAPPING_NAMEKEY), (String)field.get(LDAP_GROUP_MAPPING_ROLEKEY));
            }
        }
        if (groupMapping == null || groupMapping.isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            Map<String, Role> idToRole = this.roleService.loadAllIdMap();
            return Maps.newHashMap((Map)Maps.transformValues(groupMapping, (Function)Roles.roleIdToNameFunction(idToRole)));
        }
        catch (NotFoundException e) {
            LOG.error("Unable to load role mapping");
            return Collections.emptyMap();
        }
    }

    @Override
    public void setGroupMapping(Map<String, String> mapping) {
        HashMap internal;
        if (mapping == null) {
            internal = Collections.emptyMap();
        } else {
            try {
                ImmutableMap nameToRole = Maps.uniqueIndex(this.roleService.loadAll(), (Function)Roles.roleToNameFunction());
                internal = Maps.newHashMap((Map)Maps.transformValues(mapping, (Function)new Function<String, String>((Map)nameToRole){
                    final /* synthetic */ Map val$nameToRole;
                    {
                        this.val$nameToRole = map;
                    }

                    @Nullable
                    public String apply(@Nullable String groupName) {
                        if (groupName == null || !this.val$nameToRole.containsKey(groupName)) {
                            return null;
                        }
                        return ((Role)this.val$nameToRole.get(groupName)).getId();
                    }
                }));
            }
            catch (NotFoundException e) {
                LOG.error("Unable to convert group names to ids", (Throwable)e);
                throw new IllegalStateException("Unable to convert group names to ids", e);
            }
        }
        this.fields.put(GROUP_MAPPING_LIST, internal.entrySet().stream().map(entry -> {
            HashMap m = Maps.newHashMap();
            m.put(LDAP_GROUP_MAPPING_NAMEKEY, (String)entry.getKey());
            m.put(LDAP_GROUP_MAPPING_ROLEKEY, (String)entry.getValue());
            return m;
        }).collect(Collectors.toList()));
    }

    @Override
    public String getGroupSearchBase() {
        return Strings.nullToEmpty((String)((String)this.fields.get(GROUP_SEARCH_BASE)));
    }

    @Override
    public void setGroupSearchBase(String groupSearchBase) {
        this.fields.put(GROUP_SEARCH_BASE, groupSearchBase);
    }

    @Override
    public String getGroupIdAttribute() {
        return Strings.nullToEmpty((String)((String)this.fields.get(GROUP_ID_ATTRIBUTE)));
    }

    @Override
    public void setGroupIdAttribute(String groupIdAttribute) {
        this.fields.put(GROUP_ID_ATTRIBUTE, groupIdAttribute);
    }

    @Override
    public String getGroupSearchPattern() {
        return Strings.nullToEmpty((String)((String)this.fields.get(GROUP_SEARCH_PATTERN)));
    }

    @Override
    public void setGroupSearchPattern(String groupSearchPattern) {
        this.fields.put(GROUP_SEARCH_PATTERN, groupSearchPattern);
    }

    @Override
    public Set<String> getAdditionalDefaultGroups() {
        Set<String> additionalGroups = this.getAdditionalDefaultGroupIds();
        try {
            Map<String, Role> idToRole = this.roleService.loadAllIdMap();
            return Sets.newHashSet((Iterable)Collections2.transform(additionalGroups, (Function)Roles.roleIdToNameFunction(idToRole)));
        }
        catch (NotFoundException e) {
            LOG.error("Unable to load role mapping");
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> getAdditionalDefaultGroupIds() {
        List additionalGroups = (List)this.fields.get(ADDITIONAL_DEFAULT_GROUPS);
        return additionalGroups == null ? Collections.emptySet() : Sets.newHashSet((Iterable)additionalGroups);
    }

    @Override
    public void setAdditionalDefaultGroups(Set<String> groupNames) {
        try {
            if (groupNames == null) {
                return;
            }
            ImmutableMap nameToRole = Maps.uniqueIndex(this.roleService.loadAll(), (Function)Roles.roleToNameFunction());
            ArrayList groupIds = Lists.newArrayList((Iterable)Collections2.transform(groupNames, (Function)new Function<String, String>((Map)nameToRole){
                final /* synthetic */ Map val$nameToRole;
                {
                    this.val$nameToRole = map;
                }

                @Nullable
                public String apply(@Nullable String groupName) {
                    if (groupName == null || !this.val$nameToRole.containsKey(groupName)) {
                        return null;
                    }
                    return ((Role)this.val$nameToRole.get(groupName)).getId();
                }
            }));
            this.fields.put(ADDITIONAL_DEFAULT_GROUPS, groupIds);
        }
        catch (NotFoundException e) {
            LOG.error("Unable to convert group names to ids", (Throwable)e);
            throw new IllegalStateException("Unable to convert group names to ids", e);
        }
    }

    public static interface Factory {
        public LdapSettingsImpl createEmpty();

        public LdapSettingsImpl create(ObjectId var1, Map<String, Object> var2);
    }
}

