/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings.providers;

import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog2.database.ObjectIdSerializer;
import org.graylog2.jackson.JodaTimePeriodKeyDeserializer;
import org.graylog2.plugin.inject.JacksonSubTypes;
import org.graylog2.shared.jackson.SizeSerializer;
import org.graylog2.shared.plugins.GraylogClassLoader;
import org.graylog2.shared.rest.RangeJsonSerializer;
import org.joda.time.Period;

@Singleton
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    protected final ObjectMapper objectMapper;

    public ObjectMapperProvider() {
        this(ObjectMapperProvider.class.getClassLoader(), Collections.emptySet());
    }

    @Inject
    public ObjectMapperProvider(@GraylogClassLoader ClassLoader classLoader, @JacksonSubTypes Set<NamedType> subtypes) {
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory().withClassLoader(classLoader);
        this.objectMapper = mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.SnakeCaseStrategy()).setTypeFactory(typeFactory).registerModule((Module)new GuavaModule()).registerModule((Module)new JodaModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.SECONDS, false)).registerModule((Module)new SimpleModule("Graylog").addKeyDeserializer(Period.class, (KeyDeserializer)new JodaTimePeriodKeyDeserializer()).addSerializer((JsonSerializer)new RangeJsonSerializer()).addSerializer((JsonSerializer)new SizeSerializer()).addSerializer((JsonSerializer)new ObjectIdSerializer()));
        if (subtypes != null) {
            this.objectMapper.registerSubtypes(subtypes.toArray(new NamedType[0]));
        }
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }
}

