/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.SSLContext;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.audit.PluginAuditEventTypes;
import org.graylog2.audit.jersey.AuditEventModelProcessor;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.jersey.PrefixAddingModelProcessor;
import org.graylog2.plugin.inject.RestControllerPackage;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.filter.WebAppNotFoundResponseFilter;
import org.graylog2.shared.rest.CORSFilter;
import org.graylog2.shared.rest.NodeIdResponseFilter;
import org.graylog2.shared.rest.NotAuthorizedResponseFilter;
import org.graylog2.shared.rest.PrintModelProcessor;
import org.graylog2.shared.rest.RestAccessLogFilter;
import org.graylog2.shared.rest.XHRFilter;
import org.graylog2.shared.rest.exceptionmappers.AnyExceptionClassMapper;
import org.graylog2.shared.rest.exceptionmappers.BadRequestExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.JacksonPropertyExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.JsonProcessingExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.WebApplicationExceptionMapper;
import org.graylog2.shared.security.tls.KeyStoreUtils;
import org.graylog2.shared.security.tls.PemKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyService
extends AbstractIdleService {
    public static final String PLUGIN_PREFIX = "/plugins";
    private static final Logger LOG = LoggerFactory.getLogger(JerseyService.class);
    private static final String RESOURCE_PACKAGE_WEB = "org.graylog2.web.resources";
    private final HttpConfiguration configuration;
    private final Map<String, Set<Class<? extends PluginRestResource>>> pluginRestResources;
    private final Set<RestControllerPackage> restControllerPackages;
    private final Set<Class<? extends DynamicFeature>> dynamicFeatures;
    private final Set<Class<? extends ContainerResponseFilter>> containerResponseFilters;
    private final Set<Class<? extends ExceptionMapper>> exceptionMappers;
    private final Set<Class> additionalComponents;
    private final Set<PluginAuditEventTypes> pluginAuditEventTypes;
    private final ObjectMapper objectMapper;
    private final MetricRegistry metricRegistry;
    private final ErrorPageGenerator errorPageGenerator;
    private HttpServer apiHttpServer = null;

    @Inject
    public JerseyService(HttpConfiguration configuration, Set<Class<? extends DynamicFeature>> dynamicFeatures, Set<Class<? extends ContainerResponseFilter>> containerResponseFilters, Set<Class<? extends ExceptionMapper>> exceptionMappers, @Named(value="additionalJerseyComponents") Set<Class> additionalComponents, Map<String, Set<Class<? extends PluginRestResource>>> pluginRestResources, Set<RestControllerPackage> restControllerPackages, Set<PluginAuditEventTypes> pluginAuditEventTypes, ObjectMapper objectMapper, MetricRegistry metricRegistry, ErrorPageGenerator errorPageGenerator) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.dynamicFeatures = Objects.requireNonNull(dynamicFeatures, "dynamicFeatures");
        this.containerResponseFilters = Objects.requireNonNull(containerResponseFilters, "containerResponseFilters");
        this.exceptionMappers = Objects.requireNonNull(exceptionMappers, "exceptionMappers");
        this.additionalComponents = Objects.requireNonNull(additionalComponents, "additionalComponents");
        this.pluginRestResources = Objects.requireNonNull(pluginRestResources, "pluginResources");
        this.restControllerPackages = Objects.requireNonNull(restControllerPackages, "restControllerPackages");
        this.pluginAuditEventTypes = Objects.requireNonNull(pluginAuditEventTypes, "pluginAuditEventTypes");
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
        this.errorPageGenerator = Objects.requireNonNull(errorPageGenerator, "errorPageGenerator");
    }

    protected void startUp() throws Exception {
        System.setProperty("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        this.startUpApi();
    }

    protected void shutDown() throws Exception {
        this.shutdownHttpServer(this.apiHttpServer, this.configuration.getHttpBindAddress());
    }

    private void shutdownHttpServer(HttpServer httpServer, HostAndPort bindAddress) {
        if (httpServer != null && httpServer.isStarted()) {
            LOG.info("Shutting down HTTP listener at <{}>", (Object)bindAddress);
            httpServer.shutdownNow();
        }
    }

    private void startUpApi() throws Exception {
        ImmutableList resourcePackages = ImmutableList.builder().addAll((Iterable)this.restControllerPackages.stream().map(RestControllerPackage::name).collect(Collectors.toList())).add((Object)RESOURCE_PACKAGE_WEB).build();
        Set<Resource> pluginResources = this.prefixPluginResources(PLUGIN_PREFIX, this.pluginRestResources);
        SSLEngineConfigurator sslEngineConfigurator = this.configuration.isHttpEnableTls() ? this.buildSslEngineConfigurator(this.configuration.getHttpTlsCertFile(), this.configuration.getHttpTlsKeyFile(), this.configuration.getHttpTlsKeyPassword()) : null;
        HostAndPort bindAddress = this.configuration.getHttpBindAddress();
        String contextPath = this.configuration.getHttpPublishUri().getPath();
        URI listenUri = new URI(this.configuration.getUriScheme(), null, bindAddress.getHost(), bindAddress.getPort(), Strings.isNullOrEmpty((String)contextPath) ? "/" : contextPath, null, null);
        this.apiHttpServer = this.setUp(listenUri, sslEngineConfigurator, this.configuration.getHttpThreadPoolSize(), this.configuration.getHttpSelectorRunnersCount(), this.configuration.getHttpMaxHeaderSize(), this.configuration.isHttpEnableGzip(), this.configuration.isHttpEnableCors(), pluginResources, resourcePackages.toArray(new String[0]));
        this.apiHttpServer.start();
        LOG.info("Started REST API at <{}>", (Object)this.configuration.getHttpBindAddress());
    }

    private Set<Resource> prefixPluginResources(String pluginPrefix, Map<String, Set<Class<? extends PluginRestResource>>> pluginResourceMap) {
        return pluginResourceMap.entrySet().stream().map(entry -> this.prefixResources(pluginPrefix + "/" + (String)entry.getKey(), (Set)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T> Set<Resource> prefixResources(String prefix, Set<Class<? extends T>> resources) {
        String pathPrefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
        return resources.stream().map(resource -> {
            Path pathAnnotation = Resource.getPath((Class)resource);
            String resourcePathSuffix = Strings.nullToEmpty((String)pathAnnotation.value());
            String resourcePath = resourcePathSuffix.startsWith("/") ? pathPrefix + resourcePathSuffix : pathPrefix + "/" + resourcePathSuffix;
            return Resource.builder((Class)resource).path(resourcePath).build();
        }).collect(Collectors.toSet());
    }

    private ResourceConfig buildResourceConfig(boolean enableCors, Set<Resource> additionalResources, String[] controllerPackages) {
        HashMap<String, String> packagePrefixes = new HashMap<String, String>();
        for (String resourcePackage : controllerPackages) {
            packagePrefixes.put(resourcePackage, "api/");
        }
        packagePrefixes.put(RESOURCE_PACKAGE_WEB, "");
        packagePrefixes.put("", "api/");
        ResourceConfig rc = new ResourceConfig().property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true).property("jersey.config.server.wadl.disableWadl", (Object)true).register((Object)new PrefixAddingModelProcessor(packagePrefixes)).register((Object)new AuditEventModelProcessor(this.pluginAuditEventTypes)).registerClasses(new Class[]{JacksonJaxbJsonProvider.class, JsonProcessingExceptionMapper.class, JacksonPropertyExceptionMapper.class, AnyExceptionClassMapper.class, WebApplicationExceptionMapper.class, BadRequestExceptionMapper.class, RestAccessLogFilter.class, NodeIdResponseFilter.class, XHRFilter.class, NotAuthorizedResponseFilter.class, WebAppNotFoundResponseFilter.class}).register((Object)new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return JerseyService.this.objectMapper;
            }
        }).packages(true, controllerPackages).packages(true, new String[]{RESOURCE_PACKAGE_WEB}).registerResources(additionalResources);
        this.exceptionMappers.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.dynamicFeatures.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.containerResponseFilters.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.additionalComponents.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        if (enableCors) {
            LOG.info("Enabling CORS for HTTP endpoint");
            rc.registerClasses(new Class[]{CORSFilter.class});
        }
        if (LOG.isDebugEnabled()) {
            rc.registerClasses(new Class[]{PrintModelProcessor.class});
        }
        return rc;
    }

    private HttpServer setUp(URI listenUri, SSLEngineConfigurator sslEngineConfigurator, int threadPoolSize, int selectorRunnersCount, int maxHeaderSize, boolean enableGzip, boolean enableCors, Set<Resource> additionalResources, String[] controllerPackages) throws GeneralSecurityException, IOException {
        ResourceConfig resourceConfig = this.buildResourceConfig(enableCors, additionalResources, controllerPackages);
        HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)listenUri, (ResourceConfig)resourceConfig, (sslEngineConfigurator != null ? 1 : 0) != 0, (SSLEngineConfigurator)sslEngineConfigurator, (boolean)false);
        NetworkListener listener = httpServer.getListener("grizzly");
        listener.setMaxHttpHeaderSize(maxHeaderSize);
        ExecutorService workerThreadPoolExecutor = this.instrumentedExecutor("http-worker-executor", "http-worker-%d", threadPoolSize);
        listener.getTransport().setWorkerThreadPool(workerThreadPoolExecutor);
        listener.getTransport().setSelectorRunnersCount(selectorRunnersCount);
        listener.setDefaultErrorPageGenerator(this.errorPageGenerator);
        if (enableGzip) {
            CompressionConfig compressionConfig = listener.getCompressionConfig();
            compressionConfig.setCompressionMode(CompressionConfig.CompressionMode.ON);
            compressionConfig.setCompressionMinSize(512);
        }
        return httpServer;
    }

    private SSLEngineConfigurator buildSslEngineConfigurator(java.nio.file.Path certFile, java.nio.file.Path keyFile, String keyPassword) throws GeneralSecurityException, IOException {
        if (keyFile == null || !Files.isRegularFile(keyFile, new LinkOption[0]) || !Files.isReadable(keyFile)) {
            throw new InvalidKeyException("Unreadable or missing private key: " + keyFile);
        }
        if (certFile == null || !Files.isRegularFile(certFile, new LinkOption[0]) || !Files.isReadable(certFile)) {
            throw new CertificateException("Unreadable or missing X.509 certificate: " + certFile);
        }
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        char[] password = ((String)MoreObjects.firstNonNull((Object)keyPassword, (Object)"")).toCharArray();
        KeyStore keyStore = PemKeyStore.buildKeyStore(certFile, keyFile, password);
        sslContextConfigurator.setKeyStorePass(password);
        sslContextConfigurator.setKeyStoreBytes(KeyStoreUtils.getBytes(keyStore, password));
        SSLContext sslContext = sslContextConfigurator.createSSLContext(true);
        return new SSLEngineConfigurator(sslContext, false, false, false);
    }

    private ExecutorService instrumentedExecutor(String executorName, String threadNameFormat, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).setDaemon(true).build();
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(poolSize, threadFactory), this.metricRegistry, MetricRegistry.name(JerseyService.class, (String[])new String[]{executorName}));
    }
}

