/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.rest.resources;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.rest.models.ConfigurationSummary;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.rest.requests.ConfigurationPreviewRequest;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationListResponse;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationPreviewRenderResponse;
import org.graylog.plugins.sidecar.rest.responses.ConfigurationSidecarsResponse;
import org.graylog.plugins.sidecar.rest.responses.ValidationResponse;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog.plugins.sidecar.services.SidecarService;
import org.graylog.plugins.sidecar.template.RenderTemplateException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Sidecar/Configurations", description="Manage/Render collector configurations")
@Path(value="/sidecar/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class ConfigurationResource
extends RestResource
implements PluginRestResource {
    private final ConfigurationService configurationService;
    private final SidecarService sidecarService;
    private final EtagService etagService;
    private final SearchQueryParser searchQueryParser;
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("id")).put((Object)"collector_id", (Object)SearchQueryField.create("collector_id")).put((Object)"name", (Object)SearchQueryField.create("name")).build();

    @Inject
    public ConfigurationResource(ConfigurationService configurationService, SidecarService sidecarService, EtagService etagService) {
        this.configurationService = configurationService;
        this.sidecarService = sidecarService;
        this.etagService = etagService;
        this.searchQueryParser = new SearchQueryParser("name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @RequiresPermissions(value={"configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="List all configurations")
    public ConfigurationListResponse listConfigurations(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name,id,collector_id") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<Configuration> configurations = this.configurationService.findPaginated(searchQuery, page, perPage, sort, order);
        long total = this.configurationService.count();
        List<ConfigurationSummary> result = configurations.stream().map(ConfigurationSummary::create).collect(Collectors.toList());
        return ConfigurationListResponse.create(query, configurations.pagination(), total, sort, order, result);
    }

    @GET
    @Path(value="/{id}")
    @RequiresPermissions(value={"configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show configuration details")
    public Configuration getConfigurations(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        Configuration configuration = this.configurationService.find(id);
        if (configuration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        return configuration;
    }

    @GET
    @Path(value="/{id}/sidecars")
    @RequiresPermissions(value={"configurations:read", "sidecars:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Show sidecars using the given configuration")
    public ConfigurationSidecarsResponse getConfigurationSidecars(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        Configuration configuration = this.configurationService.find(id);
        if (configuration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        List<String> sidecarsWithConfiguration = this.sidecarService.all().stream().filter(sidecar -> this.isConfigurationAssignedToSidecar(configuration.id(), (Sidecar)sidecar)).map(Sidecar::id).collect(Collectors.toList());
        return ConfigurationSidecarsResponse.create(configuration.id(), sidecarsWithConfiguration);
    }

    @GET
    @Path(value="/validate")
    @RequiresPermissions(value={"configurations:read"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates configuration name")
    public ValidationResponse validateConfiguration(@ApiParam(name="name", required=true) @QueryParam(value="name") String name) {
        Configuration configuration = this.configurationService.findByName(name);
        if (configuration == null) {
            return ValidationResponse.create(false, null);
        }
        return ValidationResponse.create(true, "Configuration with name \"" + name + "\" already exists");
    }

    @GET
    @Path(value="/render/{sidecarId}/{configurationId}")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"configurations:read"})
    @ApiOperation(value="Render configuration template")
    public Response renderConfiguration(@Context HttpHeaders httpHeaders, @ApiParam(name="sidecarId", required=true) @PathParam(value="sidecarId") String sidecarId, @ApiParam(name="configurationId", required=true) @PathParam(value="configurationId") String configurationId) throws RenderTemplateException {
        EntityTag etag;
        String ifNoneMatch = httpHeaders.getHeaderString("If-None-Match");
        Boolean etagCached = false;
        Response.ResponseBuilder builder = Response.noContent();
        if (ifNoneMatch != null && this.etagService.isPresent((etag = new EntityTag(ifNoneMatch.replaceAll("\"", ""))).toString())) {
            etagCached = true;
            builder = Response.notModified();
            builder.tag(etag);
        }
        if (!etagCached.booleanValue()) {
            Sidecar sidecar = this.sidecarService.findByNodeId(sidecarId);
            if (sidecar == null) {
                throw new NotFoundException("Couldn't find Sidecar by ID: " + sidecarId);
            }
            Configuration configuration = this.configurationService.find(configurationId);
            if (configuration == null) {
                throw new NotFoundException("Couldn't find configuration by ID: " + configurationId);
            }
            Configuration collectorConfiguration = this.configurationService.renderConfigurationForCollector(sidecar, configuration);
            String etagString = this.configurationToEtag(collectorConfiguration);
            EntityTag collectorConfigurationEtag = new EntityTag(etagString);
            builder = Response.ok((Object)collectorConfiguration);
            builder.tag(collectorConfigurationEtag);
            this.etagService.put(collectorConfigurationEtag.toString());
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoTransform(true);
        cacheControl.setPrivate(true);
        builder.cacheControl(cacheControl);
        return builder.build();
    }

    @POST
    @Path(value="/render/preview")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"configurations:read"})
    @ApiOperation(value="Render preview of a configuration template")
    @NoAuditEvent(value="this is not changing any data")
    public ConfigurationPreviewRenderResponse renderConfiguration(@ApiParam(name="JSON body", required=true) @Valid @NotNull ConfigurationPreviewRequest request) {
        try {
            String preview = this.configurationService.renderPreview(request.template());
            return ConfigurationPreviewRenderResponse.create(preview);
        }
        catch (RenderTemplateException e) {
            throw new BadRequestException("Could not render template preview: " + e.getMessage());
        }
    }

    @POST
    @RequiresPermissions(value={"configurations:create"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create new configuration")
    @AuditEvent(type="sidecar:configuration:create")
    public Configuration createConfiguration(@ApiParam(name="JSON body", required=true) @Valid @NotNull Configuration request) {
        return this.persistConfiguration(null, request);
    }

    @POST
    @Path(value="/{id}/{name}")
    @RequiresPermissions(value={"configurations:create"})
    @ApiOperation(value="Copy a configuration")
    @AuditEvent(type="sidecar:configuration:clone")
    public Response copyConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @PathParam(value="name") String name) throws NotFoundException {
        Configuration configuration = this.configurationService.copyConfiguration(id, name);
        this.configurationService.save(configuration);
        return Response.accepted().build();
    }

    @PUT
    @Path(value="/{id}")
    @RequiresPermissions(value={"configurations:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a configuration")
    @AuditEvent(type="sidecar:configuration:update")
    public Configuration updateConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="JSON body", required=true) @Valid @NotNull Configuration request) {
        Configuration previousConfiguration = this.configurationService.find(id);
        if (previousConfiguration == null) {
            throw new NotFoundException("Could not find Configuration <" + id + ">.");
        }
        if (!previousConfiguration.collectorId().equals(request.collectorId()) && this.isConfigurationInUse(id)) {
            throw new BadRequestException("Configuration still in use, cannot change collector type.");
        }
        Configuration updatedConfiguration = this.persistConfiguration(id, request);
        this.etagService.invalidateAll();
        return updatedConfiguration;
    }

    @DELETE
    @Path(value="/{id}")
    @RequiresPermissions(value={"configurations:update"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a configuration")
    @AuditEvent(type="sidecar:configuration:delete")
    public Response deleteConfiguration(@ApiParam(name="id", required=true) @PathParam(value="id") String id) {
        if (this.isConfigurationInUse(id)) {
            throw new BadRequestException("Configuration still in use, cannot delete.");
        }
        int deleted = this.configurationService.delete(id);
        if (deleted == 0) {
            return Response.notModified().build();
        }
        this.etagService.invalidateAll();
        return Response.accepted().build();
    }

    private boolean isConfigurationInUse(String configurationId) {
        return this.sidecarService.all().stream().anyMatch(sidecar -> this.isConfigurationAssignedToSidecar(configurationId, (Sidecar)sidecar));
    }

    private boolean isConfigurationAssignedToSidecar(String configurationId, Sidecar sidecar) {
        List assignments = (List)MoreObjects.firstNonNull(sidecar.assignments(), new ArrayList());
        return assignments.stream().anyMatch(assignment -> assignment.configurationId().equals(configurationId));
    }

    private String configurationToEtag(Configuration configuration) {
        return Hashing.md5().hashInt(configuration.hashCode()).toString();
    }

    private Configuration persistConfiguration(String id, Configuration request) {
        try {
            this.configurationService.renderPreview(request.template());
        }
        catch (RenderTemplateException e) {
            throw new BadRequestException("Configuration template validation failed: " + e.getMessage());
        }
        Configuration configuration = id == null ? this.configurationService.fromRequest(request) : this.configurationService.fromRequest(id, request);
        return this.configurationService.save(configuration);
    }
}

