/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

@Singleton
public class CollectorService
extends PaginatedDbService<Collector> {
    private static final String COLLECTION_NAME = "sidecar_collectors";

    @Inject
    public CollectorService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, Collector.class, COLLECTION_NAME);
    }

    @Nullable
    public Collector find(String id) {
        return (Collector)this.db.findOne(DBQuery.is((String)"_id", (Object)id));
    }

    @Nullable
    public Collector findByName(String name) {
        return (Collector)this.db.findOne(DBQuery.is((String)"name", (Object)name));
    }

    public long count() {
        return this.db.count();
    }

    public List<Collector> allFilter(Predicate<Collector> filter) {
        try (Stream collectorsStream = this.streamAll();){
            Stream filteredStream = filter == null ? collectorsStream : collectorsStream.filter(filter);
            List<Collector> list = filteredStream.collect(Collectors.toList());
            return list;
        }
    }

    public List<Collector> all() {
        return this.allFilter(null);
    }

    public PaginatedList<Collector> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
    }

    public Collector fromRequest(Collector request) {
        return Collector.create(null, request.name(), request.serviceType(), request.nodeOperatingSystem(), request.executablePath(), request.configurationPath(), request.executeParameters(), request.validationParameters(), request.defaultTemplate());
    }

    public Collector fromRequest(String id, Collector request) {
        Collector collector = this.fromRequest(request);
        return collector.toBuilder().id(id).build();
    }

    @Nullable
    public Collector copy(String id, String name) {
        Collector collector = this.find(id);
        return collector == null ? null : collector.toBuilder().id(null).name(name).build();
    }
}

