/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

public interface EntityFacade<T> {
    public EntityWithConstraints exportNativeEntity(T var1);

    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor var1);

    public NativeEntity<T> createNativeEntity(Entity var1, Map<String, ValueReference> var2, Map<EntityDescriptor, Object> var3, String var4);

    default public Optional<NativeEntity<T>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        return Optional.empty();
    }

    public Optional<NativeEntity<T>> loadNativeEntity(NativeEntityDescriptor var1);

    public void delete(T var1);

    public EntityExcerpt createExcerpt(T var1);

    public Set<EntityExcerpt> listEntityExcerpts();

    default public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    default public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

