/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import io.krakens.grok.api.GrokUtils;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.exceptions.DivergingEntityConfigurationException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.GrokPatternEntity;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.plugin.database.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokPatternFacade
implements EntityFacade<GrokPattern> {
    private static final Logger LOG = LoggerFactory.getLogger(GrokPatternFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.GROK_PATTERN_V1;
    private final ObjectMapper objectMapper;
    private final GrokPatternService grokPatternService;

    @Inject
    public GrokPatternFacade(ObjectMapper objectMapper, GrokPatternService grokPatternService) {
        this.objectMapper = objectMapper;
        this.grokPatternService = grokPatternService;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(GrokPattern grokPattern) {
        GrokPatternEntity grokPatternEntity = GrokPatternEntity.create(ValueReference.of(grokPattern.name()), ValueReference.of(grokPattern.pattern()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)grokPatternEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(grokPattern.id()))).type(ModelTypes.GROK_PATTERN_V1)).data(data).build();
        return EntityWithConstraints.create(entity);
    }

    @Override
    public NativeEntity<GrokPattern> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<GrokPattern> decode(EntityV1 entity, Map<String, ValueReference> parameters) {
        GrokPatternEntity grokPatternEntity = (GrokPatternEntity)this.objectMapper.convertValue((Object)entity.data(), GrokPatternEntity.class);
        String name = grokPatternEntity.name().asString(parameters);
        String pattern = grokPatternEntity.pattern().asString(parameters);
        GrokPattern grokPattern = GrokPattern.create(name, pattern);
        try {
            GrokPattern savedGrokPattern = this.grokPatternService.save(grokPattern);
            return NativeEntity.create(entity.id(), savedGrokPattern.id(), TYPE_V1, savedGrokPattern.name(), savedGrokPattern);
        }
        catch (ValidationException e) {
            throw new RuntimeException("Couldn't create grok pattern " + grokPattern.name());
        }
    }

    @Override
    public Optional<NativeEntity<GrokPattern>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            GrokPattern grokPattern = this.grokPatternService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, grokPattern));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(GrokPattern nativeEntity) {
        this.grokPatternService.delete(nativeEntity.id());
    }

    @Override
    public Optional<NativeEntity<GrokPattern>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<GrokPattern>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        GrokPatternEntity grokPatternEntity = (GrokPatternEntity)this.objectMapper.convertValue((Object)entity.data(), GrokPatternEntity.class);
        String name = grokPatternEntity.name().asString(parameters);
        String pattern = grokPatternEntity.pattern().asString(parameters);
        Optional<GrokPattern> grokPattern = this.grokPatternService.loadByName(name);
        grokPattern.ifPresent(existingPattern -> this.compareGrokPatterns(name, pattern, existingPattern.pattern()));
        return grokPattern.map(gp -> NativeEntity.create(entity.id(), gp.id(), TYPE_V1, gp.name(), gp));
    }

    private void compareGrokPatterns(String name, String expectedPattern, String actualPattern) {
        if (!actualPattern.equals(expectedPattern)) {
            throw new DivergingEntityConfigurationException("Expected Grok pattern for name \"" + name + "\": <" + expectedPattern + ">; actual Grok pattern: <" + actualPattern + ">");
        }
    }

    @Override
    public EntityExcerpt createExcerpt(GrokPattern grokPattern) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(grokPattern.id()))).type(ModelTypes.GROK_PATTERN_V1)).title(grokPattern.name()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.grokPatternService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            GrokPattern grokPattern = this.grokPatternService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(grokPattern));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find grok pattern {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        try {
            GrokPattern grokPattern = this.grokPatternService.load(modelId.id());
            Set namedGroups = GrokUtils.getNameGroups((String)GrokUtils.GROK_PATTERN.pattern());
            String namedPattern = grokPattern.pattern();
            Matcher matcher = GrokUtils.GROK_PATTERN.matcher(namedPattern);
            while (matcher.find()) {
                Map group = GrokUtils.namedGroups((Matcher)matcher, (Set)namedGroups);
                String patternName = (String)group.get("pattern");
                this.grokPatternService.loadByName(patternName).ifPresent(depPattern -> {
                    EntityDescriptor depEntityDescriptor = EntityDescriptor.create(depPattern.id(), ModelTypes.GROK_PATTERN_V1);
                    mutableGraph.putEdge((Object)entityDescriptor, (Object)depEntityDescriptor);
                });
            }
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find grok pattern {}", (Object)entityDescriptor, (Object)e);
        }
        return mutableGraph;
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallationV1((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallationV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        GrokPatternEntity grokPatternEntity = (GrokPatternEntity)this.objectMapper.convertValue((Object)entity.data(), GrokPatternEntity.class);
        Set namedGroups = GrokUtils.getNameGroups((String)GrokUtils.GROK_PATTERN.pattern());
        String namedPattern = grokPatternEntity.pattern().asString(parameters);
        Matcher matcher = GrokUtils.GROK_PATTERN.matcher(namedPattern);
        while (matcher.find()) {
            Map group = GrokUtils.namedGroups((Matcher)matcher, (Set)namedGroups);
            String patternName = (String)group.get("pattern");
            entities.entrySet().stream().filter(x -> ((Entity)x.getValue()).type().equals(ModelTypes.GROK_PATTERN_V1)).filter(x -> {
                EntityV1 entityV1 = (EntityV1)x.getValue();
                GrokPatternEntity grokPatternEntity1 = (GrokPatternEntity)this.objectMapper.convertValue((Object)entityV1.data(), GrokPatternEntity.class);
                return grokPatternEntity1.name().asString(parameters).equals(patternName);
            }).forEach(x -> mutableGraph.putEdge((Object)entity, (Object)((Entity)x.getValue())));
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

