/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.ConfigurationException;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.facades.InputWithExtractors;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.ConverterEntity;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.ExtractorEntity;
import org.graylog2.contentpacks.model.entities.InputEntity;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.InputRegistry;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFacade
implements EntityFacade<InputWithExtractors> {
    private static final Logger LOG = LoggerFactory.getLogger(InputFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.INPUT_V1;
    private final ObjectMapper objectMapper;
    private final InputService inputService;
    private final InputRegistry inputRegistry;
    private final MessageInputFactory messageInputFactory;
    private final ExtractorFactory extractorFactory;
    private final ConverterFactory converterFactory;
    private final ServerStatus serverStatus;
    private final Set<PluginMetaData> pluginMetaData;
    private final Map<String, MessageInput.Factory<? extends MessageInput>> inputFactories;

    @Inject
    public InputFacade(ObjectMapper objectMapper, InputService inputService, InputRegistry inputRegistry, MessageInputFactory messageInputFactory, ExtractorFactory extractorFactory, ConverterFactory converterFactory, ServerStatus serverStatus, Set<PluginMetaData> pluginMetaData, Map<String, MessageInput.Factory<? extends MessageInput>> inputFactories) {
        this.objectMapper = objectMapper;
        this.inputService = inputService;
        this.inputRegistry = inputRegistry;
        this.messageInputFactory = messageInputFactory;
        this.extractorFactory = extractorFactory;
        this.converterFactory = converterFactory;
        this.serverStatus = serverStatus;
        this.pluginMetaData = pluginMetaData;
        this.inputFactories = inputFactories;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(InputWithExtractors inputWithExtractors) {
        Input input = inputWithExtractors.input();
        Map<String, ValueReference> staticFields = input.getStaticFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ValueReference.of((String)kv.getValue())));
        ReferenceMap configuration = ReferenceMapUtils.toReferenceMap(input.getConfiguration());
        List<ExtractorEntity> extractors = inputWithExtractors.extractors().stream().map(this::encodeExtractor).collect(Collectors.toList());
        InputEntity inputEntity = InputEntity.create(ValueReference.of(input.getTitle()), configuration, staticFields, ValueReference.of(input.getType()), ValueReference.of(input.isGlobal()), extractors);
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)inputEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(input.getId()))).type(ModelTypes.INPUT_V1)).data(data).build();
        Set<Constraint> constraints = this.versionConstraints(input);
        return EntityWithConstraints.create(entity, constraints);
    }

    private Set<Constraint> versionConstraints(Input input) {
        MessageInput.Factory<? extends MessageInput> inputFactory = this.inputFactories.get(input.getType());
        if (inputFactory == null) {
            throw new ContentPackException("Unknown input type: " + input.getType());
        }
        String packageName = inputFactory.getDescriptor().getClass().getPackage().getName();
        return this.pluginMetaData.stream().filter(metaData -> packageName.startsWith(metaData.getClass().getPackage().getName())).map(PluginVersionConstraint::of).collect(Collectors.toSet());
    }

    private ExtractorEntity encodeExtractor(Extractor extractor) {
        List<ConverterEntity> converters = extractor.getConverters().stream().map(this::encodeConverter).collect(Collectors.toList());
        return ExtractorEntity.create(ValueReference.of(extractor.getTitle()), ValueReference.of(extractor.getType()), ValueReference.of(extractor.getCursorStrategy()), ValueReference.of(extractor.getTargetField()), ValueReference.of(extractor.getSourceField()), ReferenceMapUtils.toReferenceMap(extractor.getExtractorConfig()), converters, ValueReference.of(extractor.getConditionType()), ValueReference.of(extractor.getConditionValue()), ValueReference.of(Ints.saturatedCast((long)extractor.getOrder())));
    }

    private ConverterEntity encodeConverter(Converter converter) {
        return ConverterEntity.create(ValueReference.of(converter.getType()), ReferenceMapUtils.toReferenceMap(converter.getConfig()));
    }

    @Override
    public NativeEntity<InputWithExtractors> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, username);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<InputWithExtractors> decode(EntityV1 entity, Map<String, ValueReference> parameters, String username) {
        List<Extractor> extractors;
        Input input;
        MessageInput messageInput;
        InputEntity inputEntity = (InputEntity)this.objectMapper.convertValue((Object)entity.data(), InputEntity.class);
        Map<String, ValueReference> staticFields = inputEntity.staticFields();
        try {
            messageInput = this.createMessageInput(inputEntity.title().asString(parameters), inputEntity.type().asString(parameters), inputEntity.global().asBoolean(parameters), ReferenceMapUtils.toValueMap(inputEntity.configuration(), parameters), username);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create input", e);
        }
        try {
            input = this.inputService.find(messageInput.getPersistId());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Couldn't find persisted input", e);
        }
        try {
            this.addStaticFields(input, messageInput, staticFields, parameters);
        }
        catch (ValidationException e) {
            throw new RuntimeException("Couldn't add static fields to input", e);
        }
        try {
            extractors = this.createExtractors(input, inputEntity.extractors(), username, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create extractors", e);
        }
        return NativeEntity.create(entity.id(), input.getId(), TYPE_V1, input.getTitle(), InputWithExtractors.create(input, extractors));
    }

    private MessageInput createMessageInput(String title, String type, boolean global, Map<String, Object> configuration, String username) throws NoSuchInputTypeException, org.graylog2.plugin.configuration.ConfigurationException, ValidationException {
        Configuration inputConfig = new Configuration(configuration);
        DateTime createdAt = Tools.nowUTC();
        MessageInput messageInput = this.messageInputFactory.create(type, inputConfig);
        messageInput.setTitle(title);
        messageInput.setGlobal(global);
        messageInput.setCreatorUserId(username);
        messageInput.setCreatedAt(createdAt);
        messageInput.checkConfiguration();
        if (messageInput.isExclusive() && this.inputRegistry.hasTypeRunning(messageInput.getClass())) {
            LOG.error("Input type <{}> of input <{}> is exclusive and already has input running.", messageInput.getClass(), (Object)messageInput.getTitle());
        }
        Input mongoInput = this.inputService.create(this.buildMongoDbInput(title, type, global, configuration, username, createdAt));
        String persistId = this.inputService.save(mongoInput);
        messageInput.setPersistId(persistId);
        messageInput.initialize();
        return messageInput;
    }

    private List<Extractor> createExtractors(Input input, List<ExtractorEntity> extractorEntities, String username, Map<String, ValueReference> parameters) throws Extractor.ReservedFieldException, ConfigurationException, ExtractorFactory.NoSuchExtractorException, ValidationException {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ExtractorEntity extractorEntity : extractorEntities) {
            List<Converter> converters = this.createConverters(extractorEntity.converters(), parameters);
            Extractor extractor = this.addExtractor(input, extractorEntity.title().asString(parameters), extractorEntity.order().asInteger(parameters), extractorEntity.cursorStrategy().asEnum(parameters, Extractor.CursorStrategy.class), extractorEntity.type().asEnum(parameters, Extractor.Type.class), extractorEntity.sourceField().asString(parameters), extractorEntity.targetField().asString(parameters), ReferenceMapUtils.toValueMap(extractorEntity.configuration(), parameters), converters, extractorEntity.conditionType().asEnum(parameters, Extractor.ConditionType.class), extractorEntity.conditionValue().asString(parameters), username);
            result.add((Object)extractor);
        }
        return result.build();
    }

    private Extractor addExtractor(Input input, String title, int order, Extractor.CursorStrategy cursorStrategy, Extractor.Type type, String sourceField, String targetField, Map<String, Object> configuration, List<Converter> converters, Extractor.ConditionType conditionType, String conditionValue, String username) throws ValidationException, ConfigurationException, ExtractorFactory.NoSuchExtractorException, Extractor.ReservedFieldException {
        String extractorId = UUID.randomUUID().toString();
        Extractor extractor = this.extractorFactory.factory(extractorId, title, order, cursorStrategy, type, sourceField, targetField, configuration, username, converters, conditionType, conditionValue);
        this.inputService.addExtractor(input, extractor);
        return extractor;
    }

    private List<Converter> createConverters(List<ConverterEntity> requestedConverters, Map<String, ValueReference> parameters) {
        ImmutableList.Builder converters = ImmutableList.builder();
        for (ConverterEntity converterEntity : requestedConverters) {
            try {
                Converter converter = this.converterFactory.create(converterEntity.type().asEnum(parameters, Converter.Type.class), ReferenceMapUtils.toValueMap(converterEntity.configuration(), parameters));
                converters.add((Object)converter);
            }
            catch (ConverterFactory.NoSuchConverterException e) {
                LOG.warn("No such converter [" + converterEntity.type() + "]. Skipping.", (Throwable)e);
            }
            catch (ConfigurationException e) {
                LOG.warn("Missing configuration for [" + converterEntity.type() + "]. Skipping.", (Throwable)e);
            }
        }
        return converters.build();
    }

    private void addStaticFields(Input input, MessageInput messageInput, Map<String, ValueReference> staticFields, Map<String, ValueReference> parameters) throws ValidationException {
        for (Map.Entry<String, ValueReference> staticField : staticFields.entrySet()) {
            this.addStaticField(input, messageInput, staticField.getKey(), staticField.getValue().asString(parameters));
        }
    }

    private void addStaticField(Input input, MessageInput messageInput, String key, String value) throws ValidationException {
        if (!Message.validKey(key)) {
            String errorMessage = "Invalid key: [" + key + "]";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) {
            String errorMessage = "Missing attributes: key=[" + key + "], value=[" + value + "]";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        if (Message.RESERVED_FIELDS.contains((Object)key) && !Message.RESERVED_SETTABLE_FIELDS.contains((Object)key)) {
            String errorMessage = "Cannot add static field. Field [" + key + "] is reserved.";
            LOG.error(errorMessage);
            throw new ValidationException(errorMessage);
        }
        messageInput.addStaticField(key, value);
        this.inputService.addStaticField(input, key, value);
    }

    private Map<String, Object> buildMongoDbInput(String title, String type, boolean global, Map<String, Object> configuration, String userName, DateTime createdAt) {
        ImmutableMap.Builder inputData = ImmutableMap.builder();
        inputData.put((Object)"title", (Object)title);
        inputData.put((Object)"type", (Object)type);
        inputData.put((Object)"creator_user_id", (Object)userName);
        inputData.put((Object)"configuration", configuration);
        inputData.put((Object)"created_at", (Object)createdAt);
        if (global) {
            inputData.put((Object)"global", (Object)true);
        } else {
            inputData.put((Object)"node_id", (Object)this.serverStatus.getNodeId().toString());
        }
        return inputData.build();
    }

    @Override
    public Optional<NativeEntity<InputWithExtractors>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            InputWithExtractors input = InputWithExtractors.create(this.inputService.find(nativeEntityDescriptor.id().id()));
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, input));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(InputWithExtractors nativeEntity) {
        this.inputService.destroy(nativeEntity.input());
    }

    @Override
    public EntityExcerpt createExcerpt(InputWithExtractors inputWithExtractors) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(inputWithExtractors.input().getId()))).type(ModelTypes.INPUT_V1)).title(inputWithExtractors.input().getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.inputService.all().stream().map(InputWithExtractors::create).map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            Input input = this.inputService.find(modelId.id());
            InputWithExtractors inputWithExtractors = InputWithExtractors.create(input, this.inputService.getExtractors(input));
            return Optional.of(this.exportNativeEntity(inputWithExtractors));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }
}

