/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.exceptions.DivergingEntityConfigurationException;
import org.graylog2.contentpacks.exceptions.MissingNativeEntityException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.LookupTableEntity;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.lookup.LookupDefaultValue;
import org.graylog2.lookup.db.DBLookupTableService;
import org.graylog2.lookup.dto.CacheDto;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.dto.LookupTableDto;

public class LookupTableFacade
implements EntityFacade<LookupTableDto> {
    public static final ModelType TYPE_V1 = ModelTypes.LOOKUP_TABLE_V1;
    private final ObjectMapper objectMapper;
    private final DBLookupTableService lookupTableService;

    @Inject
    public LookupTableFacade(ObjectMapper objectMapper, DBLookupTableService lookupTableService) {
        this.objectMapper = objectMapper;
        this.lookupTableService = lookupTableService;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(LookupTableDto lookupTableDto) {
        LookupTableEntity lookupTableEntity = LookupTableEntity.create(ValueReference.of(lookupTableDto.name()), ValueReference.of(lookupTableDto.title()), ValueReference.of(lookupTableDto.description()), ValueReference.of(lookupTableDto.cacheId()), ValueReference.of(lookupTableDto.dataAdapterId()), ValueReference.of(lookupTableDto.defaultSingleValue()), ValueReference.of(lookupTableDto.defaultSingleValueType()), ValueReference.of(lookupTableDto.defaultMultiValue()), ValueReference.of(lookupTableDto.defaultMultiValueType()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)lookupTableEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(lookupTableDto.id()))).type(ModelTypes.LOOKUP_TABLE_V1)).data(data).build();
        return EntityWithConstraints.create(entity);
    }

    @Override
    public NativeEntity<LookupTableDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<LookupTableDto> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        LookupTableEntity lookupTableEntity = (LookupTableEntity)this.objectMapper.convertValue((Object)entity.data(), LookupTableEntity.class);
        String referencedDataAdapterName = lookupTableEntity.dataAdapterName().asString(parameters);
        EntityDescriptor dataAdapterDescriptor = EntityDescriptor.create(referencedDataAdapterName, ModelTypes.LOOKUP_ADAPTER_V1);
        Object dataAdapter = nativeEntities.get(dataAdapterDescriptor);
        if (!(dataAdapter instanceof DataAdapterDto)) {
            throw new MissingNativeEntityException(dataAdapterDescriptor);
        }
        String dataAdapterId = ((DataAdapterDto)dataAdapter).id();
        String referencedCacheName = lookupTableEntity.cacheName().asString(parameters);
        EntityDescriptor cacheDescriptor = EntityDescriptor.create(referencedCacheName, ModelTypes.LOOKUP_CACHE_V1);
        Object cache = nativeEntities.get(cacheDescriptor);
        if (!(cache instanceof CacheDto)) {
            throw new MissingNativeEntityException(cacheDescriptor);
        }
        String cacheId = ((CacheDto)cache).id();
        LookupTableDto lookupTableDto = LookupTableDto.builder().name(lookupTableEntity.name().asString(parameters)).title(lookupTableEntity.title().asString(parameters)).description(lookupTableEntity.description().asString(parameters)).dataAdapterId(dataAdapterId).cacheId(cacheId).defaultSingleValue(lookupTableEntity.defaultSingleValue().asString(parameters)).defaultSingleValueType(lookupTableEntity.defaultSingleValueType().asEnum(parameters, LookupDefaultValue.Type.class)).defaultMultiValue(lookupTableEntity.defaultMultiValue().asString(parameters)).defaultMultiValueType(lookupTableEntity.defaultMultiValueType().asEnum(parameters, LookupDefaultValue.Type.class)).build();
        LookupTableDto savedLookupTableDto = this.lookupTableService.save(lookupTableDto);
        return NativeEntity.create(entity.id(), savedLookupTableDto.id(), TYPE_V1, lookupTableDto.title(), savedLookupTableDto);
    }

    @Override
    public Optional<NativeEntity<LookupTableDto>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<LookupTableDto>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        LookupTableEntity lookupTableEntity = (LookupTableEntity)this.objectMapper.convertValue((Object)entity.data(), LookupTableEntity.class);
        String name = lookupTableEntity.name().asString(parameters);
        String title = lookupTableEntity.title().asString(parameters);
        Optional<LookupTableDto> lookupTable = this.lookupTableService.get(name);
        lookupTable.ifPresent(existingLookupTable -> this.compareLookupTable(name, title, (LookupTableDto)existingLookupTable));
        return lookupTable.map(lt -> NativeEntity.create(entity.id(), lt.id(), TYPE_V1, lt.title(), lt));
    }

    private void compareLookupTable(String name, String title, LookupTableDto existingLookupTable) {
        if (!name.equals(existingLookupTable.name()) || !title.equals(existingLookupTable.title())) {
            throw new DivergingEntityConfigurationException("Different lookup table configuration with name \"" + name + "\"");
        }
    }

    @Override
    public Optional<NativeEntity<LookupTableDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        return this.lookupTableService.get(nativeEntityDescriptor.id().id()).map(entity -> NativeEntity.create(nativeEntityDescriptor, entity));
    }

    @Override
    public void delete(LookupTableDto nativeEntity) {
        this.lookupTableService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(LookupTableDto lookupTableDto) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(lookupTableDto.name()))).type(ModelTypes.LOOKUP_TABLE_V1)).title(lookupTableDto.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.lookupTableService.findAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        return this.lookupTableService.get(modelId.id()).map(this::exportNativeEntity);
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        Optional<LookupTableDto> lookupTableDto = this.lookupTableService.get(modelId.id());
        lookupTableDto.map(LookupTableDto::dataAdapterId).map(dataAdapterId -> EntityDescriptor.create(dataAdapterId, ModelTypes.LOOKUP_ADAPTER_V1)).ifPresent(dataAdapter -> mutableGraph.putEdge((Object)entityDescriptor, dataAdapter));
        lookupTableDto.map(LookupTableDto::cacheId).map(cacheId -> EntityDescriptor.create(cacheId, ModelTypes.LOOKUP_CACHE_V1)).ifPresent(cache -> mutableGraph.putEdge((Object)entityDescriptor, cache));
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallation((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        LookupTableEntity lookupTableEntity = (LookupTableEntity)this.objectMapper.convertValue((Object)entity.data(), LookupTableEntity.class);
        String dataAdapterName = lookupTableEntity.dataAdapterName().asString(parameters);
        EntityDescriptor dataAdapterDescriptor = EntityDescriptor.create(dataAdapterName, ModelTypes.LOOKUP_ADAPTER_V1);
        Entity dataAdapterEntity = entities.get(dataAdapterDescriptor);
        if (dataAdapterEntity == null) {
            throw new ContentPackException("Missing data adapter \"" + dataAdapterName + "\" for lookup table " + entity.toEntityDescriptor());
        }
        mutableGraph.putEdge((Object)entity, (Object)dataAdapterEntity);
        String cacheName = lookupTableEntity.cacheName().asString(parameters);
        EntityDescriptor cacheDescriptor = EntityDescriptor.create(cacheName, ModelTypes.LOOKUP_CACHE_V1);
        Entity cacheEntity = entities.get(cacheDescriptor);
        if (cacheEntity == null) {
            throw new ContentPackException("Missing cache \"" + cacheName + "\" for lookup table " + entity.toEntityDescriptor());
        }
        mutableGraph.putEdge((Object)entity, (Object)cacheEntity);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

