/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.OutputEntity;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.models.streams.outputs.requests.CreateOutputRequest;
import org.graylog2.streams.OutputService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputFacade
implements EntityFacade<Output> {
    private static final Logger LOG = LoggerFactory.getLogger(OutputFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.OUTPUT_V1;
    private final ObjectMapper objectMapper;
    private final OutputService outputService;
    private final Set<PluginMetaData> pluginMetaData;
    private final Map<String, MessageOutput.Factory<? extends MessageOutput>> outputFactories;

    @Inject
    public OutputFacade(ObjectMapper objectMapper, OutputService outputService, Set<PluginMetaData> pluginMetaData, Map<String, MessageOutput.Factory<? extends MessageOutput>> outputFactories) {
        this.objectMapper = objectMapper;
        this.outputService = outputService;
        this.pluginMetaData = pluginMetaData;
        this.outputFactories = outputFactories;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(Output output) {
        OutputEntity outputEntity = OutputEntity.create(ValueReference.of(output.getTitle()), ValueReference.of(output.getType()), ReferenceMapUtils.toReferenceMap(output.getConfiguration()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)outputEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(output.getId()))).type(ModelTypes.OUTPUT_V1)).data(data).build();
        Set<Constraint> constraints = this.versionConstraints(output);
        return EntityWithConstraints.create(entity, constraints);
    }

    private Set<Constraint> versionConstraints(Output output) {
        MessageOutput.Factory<? extends MessageOutput> outputFactory = this.outputFactories.get(output.getType());
        if (outputFactory == null) {
            throw new ContentPackException("Unknown output type: " + output.getType());
        }
        String packageName = outputFactory.getDescriptor().getClass().getPackage().getName();
        return this.pluginMetaData.stream().filter(metaData -> packageName.startsWith(metaData.getClass().getPackage().getName())).map(PluginVersionConstraint::of).collect(Collectors.toSet());
    }

    @Override
    public NativeEntity<Output> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, username);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<Output> decode(EntityV1 entity, Map<String, ValueReference> parameters, String username) {
        OutputEntity outputEntity = (OutputEntity)this.objectMapper.convertValue((Object)entity.data(), OutputEntity.class);
        CreateOutputRequest createOutputRequest = CreateOutputRequest.create(outputEntity.title().asString(parameters), outputEntity.type().asString(parameters), ReferenceMapUtils.toValueMap(outputEntity.configuration(), parameters), null);
        try {
            Output output = this.outputService.create(createOutputRequest, username);
            return NativeEntity.create(entity.id(), output.getId(), TYPE_V1, output.getTitle(), output);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Optional<NativeEntity<Output>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            Output output = this.outputService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, output));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(Output nativeEntity) {
        try {
            this.outputService.destroy(nativeEntity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public EntityExcerpt createExcerpt(Output output) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(output.getId()))).type(ModelTypes.OUTPUT_V1)).title(output.getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.outputService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            Output output = this.outputService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(output));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find output {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }
}

