/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.db.RuleDao;
import org.graylog.plugins.pipelineprocessor.db.RuleService;
import org.graylog2.contentpacks.exceptions.DivergingEntityConfigurationException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.PipelineRuleEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineRuleFacade
implements EntityFacade<RuleDao> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineRuleFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.PIPELINE_RULE_V1;
    private final ObjectMapper objectMapper;
    private final RuleService ruleService;

    @Inject
    public PipelineRuleFacade(ObjectMapper objectMapper, RuleService ruleService) {
        this.objectMapper = objectMapper;
        this.ruleService = ruleService;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(RuleDao ruleDao) {
        PipelineRuleEntity ruleEntity = PipelineRuleEntity.create(ValueReference.of(ruleDao.title()), ValueReference.of(ruleDao.description()), ValueReference.of(ruleDao.source()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)ruleEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(ruleDao.title()))).type(ModelTypes.PIPELINE_RULE_V1)).data(data).build();
        return EntityWithConstraints.create(entity);
    }

    @Override
    public NativeEntity<RuleDao> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<RuleDao> decode(EntityV1 entity, Map<String, ValueReference> parameters) {
        PipelineRuleEntity ruleEntity = (PipelineRuleEntity)this.objectMapper.convertValue((Object)entity.data(), PipelineRuleEntity.class);
        String title = ruleEntity.title().asString(parameters);
        String source = ruleEntity.source().asString(parameters);
        DateTime now = Tools.nowUTC();
        ValueReference description = ruleEntity.description();
        RuleDao ruleDao = RuleDao.builder().title(title).description(description == null ? null : description.asString(parameters)).source(source).createdAt(now).modifiedAt(now).build();
        RuleDao savedRuleDao = this.ruleService.save(ruleDao);
        return NativeEntity.create(entity.id(), savedRuleDao.id(), TYPE_V1, savedRuleDao.title(), savedRuleDao);
    }

    @Override
    public Optional<NativeEntity<RuleDao>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            RuleDao ruleDao = this.ruleService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, ruleDao));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(RuleDao nativeEntity) {
        this.ruleService.delete(nativeEntity.id());
    }

    @Override
    public Optional<NativeEntity<RuleDao>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<RuleDao>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        PipelineRuleEntity ruleEntity = (PipelineRuleEntity)this.objectMapper.convertValue((Object)entity.data(), PipelineRuleEntity.class);
        String title = ruleEntity.title().asString(parameters);
        String source = ruleEntity.source().asString(parameters);
        try {
            RuleDao ruleDao = this.ruleService.loadByName(title);
            this.compareRuleSources(title, source, ruleDao.source());
            return Optional.of(NativeEntity.create(entity.id(), ruleDao.id(), TYPE_V1, ruleDao.title(), ruleDao));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    private void compareRuleSources(String name, String expectedRuleSource, String actualRuleSource) {
        if (!actualRuleSource.equals(expectedRuleSource)) {
            LOG.debug("Expected source for rule \"{}\":\n{}\n\nActual source:\n{}", new Object[]{name, expectedRuleSource, actualRuleSource});
            throw new DivergingEntityConfigurationException("Different pipeline rule sources for pipeline rule with name \"" + name + "\"");
        }
    }

    @Override
    public EntityExcerpt createExcerpt(RuleDao ruleDao) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(ruleDao.title()))).type(ModelTypes.PIPELINE_RULE_V1)).title(ruleDao.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.ruleService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            RuleDao ruleDao = this.ruleService.loadByName(modelId.id());
            return Optional.of(this.exportNativeEntity(ruleDao));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find pipeline rule {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }
}

