/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.EntityWithConstraints;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.StreamEntity;
import org.graylog2.contentpacks.model.entities.StreamRuleEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.plugin.streams.StreamRuleType;
import org.graylog2.rest.resources.streams.requests.CreateStreamRequest;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;
import org.graylog2.streams.StreamRuleService;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFacade
implements EntityFacade<Stream> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamFacade.class);
    private static final String DUMMY_STREAM_ID = "ffffffffffffffffffffffff";
    public static final ModelType TYPE_V1 = ModelTypes.STREAM_V1;
    private final ObjectMapper objectMapper;
    private final StreamService streamService;
    private final StreamRuleService streamRuleService;
    private final IndexSetService indexSetService;

    @Inject
    public StreamFacade(ObjectMapper objectMapper, StreamService streamService, StreamRuleService streamRuleService, IndexSetService indexSetService) {
        this.objectMapper = objectMapper;
        this.streamService = streamService;
        this.streamRuleService = streamRuleService;
        this.indexSetService = indexSetService;
    }

    @Override
    public EntityWithConstraints exportNativeEntity(Stream stream) {
        List<StreamRuleEntity> streamRules = stream.getStreamRules().stream().map(this::encodeStreamRule).collect(Collectors.toList());
        Set<ValueReference> outputIds = stream.getOutputs().stream().map(Output::getId).map(ValueReference::of).collect(Collectors.toSet());
        StreamEntity streamEntity = StreamEntity.create(ValueReference.of(stream.getTitle()), ValueReference.of(stream.getDescription()), ValueReference.of(stream.getDisabled()), ValueReference.of(stream.getMatchingType()), streamRules, outputIds, ValueReference.of(stream.isDefaultStream()), ValueReference.of(stream.getRemoveMatchesFromDefaultStream()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)streamEntity, JsonNode.class);
        EntityV1 entity = ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(stream.getId()))).type(ModelTypes.STREAM_V1)).data(data).build();
        return EntityWithConstraints.create(entity);
    }

    private StreamRuleEntity encodeStreamRule(StreamRule streamRule) {
        return StreamRuleEntity.create(ValueReference.of(streamRule.getType()), ValueReference.of(streamRule.getField()), ValueReference.of(streamRule.getValue()), ValueReference.of(streamRule.getInverted()), ValueReference.of(streamRule.getDescription()));
    }

    @Override
    public NativeEntity<Stream> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities, username);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<Stream> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        String savedStreamId;
        StreamEntity streamEntity = (StreamEntity)this.objectMapper.convertValue((Object)entity.data(), StreamEntity.class);
        CreateStreamRequest createStreamRequest = CreateStreamRequest.create(streamEntity.title().asString(parameters), streamEntity.description().asString(parameters), null, null, streamEntity.matchingType().asString(parameters), streamEntity.removeMatches().asBoolean(parameters), this.indexSetService.getDefault().id());
        Stream stream = this.streamService.create(createStreamRequest, username);
        List<StreamRule> streamRules = streamEntity.streamRules().stream().map(streamRuleEntity -> this.createStreamRuleRequest((StreamRuleEntity)streamRuleEntity, parameters)).map(request -> this.streamRuleService.create(DUMMY_STREAM_ID, (CreateStreamRuleRequest)request)).collect(Collectors.toList());
        try {
            savedStreamId = this.streamService.saveWithRules(stream, streamRules);
        }
        catch (ValidationException e) {
            throw new ContentPackException("Couldn't create entity " + entity.toEntityDescriptor(), e);
        }
        Set<ObjectId> outputIds = streamEntity.outputs().stream().map(valueReference -> valueReference.asString(parameters)).map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.OUTPUT_V1)).map(descriptor -> this.findOutput((EntityDescriptor)descriptor, nativeEntities)).map(Output::getId).map(ObjectId::new).collect(Collectors.toSet());
        this.streamService.addOutputs(new ObjectId(savedStreamId), outputIds);
        return NativeEntity.create(entity.id(), savedStreamId, TYPE_V1, stream.getTitle(), stream);
    }

    private CreateStreamRuleRequest createStreamRuleRequest(StreamRuleEntity streamRuleEntity, Map<String, ValueReference> parameters) {
        return CreateStreamRuleRequest.create(streamRuleEntity.type().asEnum(parameters, StreamRuleType.class).getValue(), streamRuleEntity.value().asString(parameters), streamRuleEntity.field().asString(parameters), streamRuleEntity.inverted().asBoolean(parameters), streamRuleEntity.description().asString(parameters));
    }

    private Output findOutput(EntityDescriptor outputDescriptor, Map<EntityDescriptor, Object> nativeEntities) {
        Object output = nativeEntities.get(outputDescriptor);
        if (output == null) {
            throw new ContentPackException("Missing referenced output: " + outputDescriptor);
        }
        if (output instanceof Output) {
            return (Output)output;
        }
        String msg = "Invalid entity type for referenced output " + outputDescriptor + ": " + output.getClass();
        throw new ContentPackException(msg);
    }

    @Override
    public Optional<NativeEntity<Stream>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Optional<NativeEntity<Stream>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        String streamId = entity.id().id();
        if ("000000000000000000000001".equals(streamId)) {
            try {
                Stream stream = this.streamService.load("000000000000000000000001");
                return Optional.of(NativeEntity.create(entity.id(), "000000000000000000000001", ModelTypes.STREAM_V1, stream.getTitle(), stream));
            }
            catch (NotFoundException e) {
                throw new ContentPackException("Default stream <" + streamId + "> does not exist!", e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<NativeEntity<Stream>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            Stream stream = this.streamService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, stream));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(Stream nativeEntity) {
        if (nativeEntity.isDefaultStream()) {
            LOG.debug("The default stream should not be deleted");
            return;
        }
        try {
            this.streamService.destroy(nativeEntity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public EntityExcerpt createExcerpt(Stream stream) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(stream.getId()))).type(ModelTypes.STREAM_V1)).title(stream.getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.streamService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<EntityWithConstraints> exportEntity(EntityDescriptor entityDescriptor) {
        ModelId modelId = entityDescriptor.id();
        try {
            Stream stream = this.streamService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(stream));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find stream {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        try {
            Stream stream = this.streamService.load(modelId.id());
            stream.getOutputs().stream().map(Output::getId).map(ModelId::of).map(id -> EntityDescriptor.create(id, ModelTypes.OUTPUT_V1)).forEach(output -> mutableGraph.putEdge((Object)entityDescriptor, output));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find stream {}", (Object)entityDescriptor, (Object)e);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallation((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        StreamEntity streamEntity = (StreamEntity)this.objectMapper.convertValue((Object)entity.data(), StreamEntity.class);
        streamEntity.outputs().stream().map(valueReference -> valueReference.asString(parameters)).map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.OUTPUT_V1)).map(entities::get).filter(Objects::nonNull).forEach(outputEntity -> mutableGraph.putEdge((Object)entity, outputEntity));
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

