/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graylog2.contentpacks.model.entities.references.Reference;
import org.graylog2.contentpacks.model.entities.references.ReferenceList;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.contentpacks.model.entities.references.ValueType;

public class ReferenceConverter
extends StdConverter<JsonNode, Reference> {
    private static final ImmutableSet<String> EXPECTED_FIELD_NAMES = ImmutableSet.of((Object)"type", (Object)"value");

    public Reference convert(JsonNode jsonNode) {
        if (jsonNode.isObject()) {
            ImmutableSet fieldNames = ImmutableSet.copyOf((Iterator)jsonNode.fieldNames());
            if (fieldNames.equals(EXPECTED_FIELD_NAMES)) {
                String valueTypeText = jsonNode.path("type").asText();
                ValueType valueType = ValueType.valueOf(valueTypeText.toUpperCase(Locale.ROOT));
                JsonNode value = jsonNode.path("value");
                if (valueType == ValueType.BOOLEAN && value.isBoolean()) {
                    return ValueReference.of(value.booleanValue());
                }
                if (valueType == ValueType.DOUBLE && value.isDouble()) {
                    return ValueReference.of(value.doubleValue());
                }
                if (valueType == ValueType.FLOAT && value.isFloat()) {
                    return ValueReference.of(Float.valueOf(value.floatValue()));
                }
                if (valueType == ValueType.INTEGER && value.isInt()) {
                    return ValueReference.of(value.intValue());
                }
                if (valueType == ValueType.LONG && (value.isLong() || value.isInt())) {
                    return ValueReference.of(value.longValue());
                }
                if (valueType == ValueType.STRING && value.isTextual()) {
                    return ValueReference.of(value.textValue());
                }
                if (valueType == ValueType.PARAMETER && value.isTextual()) {
                    return ValueReference.createParameter(value.textValue());
                }
                return null;
            }
            ImmutableMap.Builder map = ImmutableMap.builder();
            Iterator fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                map.put((Object)((String)entry.getKey()), (Object)this.convert((JsonNode)entry.getValue()));
            }
            return new ReferenceMap((Map<String, Reference>)map.build());
        }
        if (jsonNode.isArray()) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (JsonNode value : jsonNode) {
                list.add((Object)this.convert(value));
            }
            return new ReferenceList((List<Reference>)list.build());
        }
        return null;
    }
}

