/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.contentpacks.model.AutoValue_ContentPackV1;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackView;
import org.graylog2.contentpacks.model.ModelVersion;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.parameters.Parameter;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_ContentPackV1.Builder.class)
@AutoValue
public abstract class ContentPackV1
implements ContentPack {
    static final String VERSION = "1";
    static final String FIELD_NAME = "name";
    static final String FIELD_SUMMARY = "summary";
    static final String FIELD_DESCRIPTION = "description";
    static final String FIELD_VENDOR = "vendor";
    static final String FIELD_URL = "url";
    static final String FIELD_REQUIRES = "requires";
    static final String FIELD_PARAMETERS = "parameters";
    static final String FIELD_ENTITIES = "entities";
    static final String FIELD_DB_ID = "_id";

    @Nullable
    @JsonView(value={ContentPackView.DBView.class})
    @JsonProperty(value="_id")
    public abstract ObjectId _id();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="name")
    public abstract String name();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="summary")
    public abstract String summary();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="description")
    public abstract String description();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="vendor")
    public abstract String vendor();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="url")
    public abstract URI url();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="requires")
    public abstract ImmutableSet<Constraint> requires();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="parameters")
    public abstract ImmutableSet<Parameter> parameters();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="entities")
    public abstract ImmutableSet<Entity> entities();

    public static Builder builder() {
        return new AutoValue_ContentPackV1.Builder().requires((ImmutableSet<Constraint>)ImmutableSet.of()).parameters((ImmutableSet<Parameter>)ImmutableSet.of());
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements ContentPack.ContentPackBuilder<Builder> {
        @JsonProperty(value="_id")
        @JsonView(value={ContentPackView.DBView.class})
        public abstract Builder _id(ObjectId var1);

        @JsonProperty(value="name")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder name(String var1);

        @JsonProperty(value="summary")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder summary(String var1);

        @JsonProperty(value="description")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder description(String var1);

        @JsonProperty(value="vendor")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder vendor(String var1);

        @JsonProperty(value="url")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder url(URI var1);

        @JsonProperty(value="requires")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder requires(ImmutableSet<Constraint> var1);

        @JsonProperty(value="parameters")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder parameters(ImmutableSet<Parameter> var1);

        @JsonProperty(value="entities")
        @JsonView(value={ContentPackView.HttpView.class})
        public abstract Builder entities(ImmutableSet<Entity> var1);

        abstract ContentPackV1 autoBuild();

        public ContentPackV1 build() {
            this.version(ModelVersion.of(ContentPackV1.VERSION));
            return this.autoBuild();
        }
    }
}

