/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.parameters;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.graylog2.contentpacks.model.entities.references.ValueType;
import org.graylog2.contentpacks.model.parameters.DoubleParameter;

final class AutoValue_DoubleParameter
extends DoubleParameter {
    private final ValueType valueType;
    private final String name;
    private final String title;
    private final String description;
    private final Optional<Double> defaultValue;

    private AutoValue_DoubleParameter(ValueType valueType, String name, String title, String description, Optional<Double> defaultValue) {
        this.valueType = valueType;
        this.name = name;
        this.title = title;
        this.description = description;
        this.defaultValue = defaultValue;
    }

    @Override
    @JsonProperty(value="type")
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="default_value")
    public Optional<Double> defaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "DoubleParameter{valueType=" + (Object)((Object)this.valueType) + ", name=" + this.name + ", title=" + this.title + ", description=" + this.description + ", defaultValue=" + this.defaultValue + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleParameter) {
            DoubleParameter that = (DoubleParameter)o;
            return this.valueType.equals((Object)that.valueType()) && this.name.equals(that.name()) && this.title.equals(that.title()) && this.description.equals(that.description()) && this.defaultValue.equals(that.defaultValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.valueType.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        return h$ ^= this.defaultValue.hashCode();
    }

    static final class Builder
    extends DoubleParameter.Builder {
        private ValueType valueType;
        private String name;
        private String title;
        private String description;
        private Optional<Double> defaultValue = Optional.empty();

        Builder() {
        }

        @Override
        public DoubleParameter.Builder valueType(ValueType valueType) {
            if (valueType == null) {
                throw new NullPointerException("Null valueType");
            }
            this.valueType = valueType;
            return this;
        }

        @Override
        public DoubleParameter.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public DoubleParameter.Builder title(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public DoubleParameter.Builder description(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public DoubleParameter.Builder defaultValue(Optional defaultValue) {
            if (defaultValue == null) {
                throw new NullPointerException("Null defaultValue");
            }
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        DoubleParameter autoBuild() {
            String missing = "";
            if (this.valueType == null) {
                missing = missing + " valueType";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.title == null) {
                missing = missing + " title";
            }
            if (this.description == null) {
                missing = missing + " description";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DoubleParameter(this.valueType, this.name, this.title, this.description, this.defaultValue);
        }
    }
}

