/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.graylog2.database.AutoValue_PaginatedList_PaginationInfo;

public class PaginatedList<E>
extends ForwardingList<E> {
    private final List<E> delegate;
    private final PaginationInfo paginationInfo;

    public PaginatedList(@Nonnull List<E> delegate, int total, int page, int perPage) {
        this.delegate = delegate;
        this.paginationInfo = PaginationInfo.create(total, delegate.size(), page, perPage);
    }

    public List<E> delegate() {
        return this.delegate;
    }

    public PaginationInfo pagination() {
        return this.paginationInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaginatedList)) {
            return false;
        }
        PaginatedList that = (PaginatedList)((Object)o);
        return Objects.equals(this.pagination(), that.pagination()) && Objects.equals(this.delegate(), that.delegate());
    }

    public int hashCode() {
        return Objects.hash(this.delegate(), this.pagination());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("content", this.delegate).add("pagination_info", (Object)this.pagination()).toString();
    }

    public static <T> PaginatedList<T> emptyList(int page, int perPage) {
        return new PaginatedList(Collections.emptyList(), 0, page, perPage);
    }

    public static <T> PaginatedList<T> singleton(T entry, int page, int perPage) {
        return new PaginatedList<T>(Collections.singletonList(entry), 1, page, perPage);
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class PaginationInfo {
        @JsonProperty(value="total")
        public abstract int total();

        @JsonProperty(value="count")
        public abstract int count();

        @JsonProperty(value="page")
        public abstract int page();

        @JsonProperty(value="per_page")
        public abstract int perPage();

        public static PaginationInfo create(int total, int count, int page, int perPage) {
            return new AutoValue_PaginatedList_PaginationInfo(total, count, page, perPage);
        }

        public ImmutableMap<String, Object> asMap() {
            return ImmutableMap.of((Object)"total", (Object)this.total(), (Object)"page", (Object)this.page(), (Object)"per_page", (Object)this.perPage(), (Object)"count", (Object)this.count());
        }
    }
}

